# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include schemas_service.R
NULL

#' Creates a discoverer
#'
#' @description
#' Creates a discoverer.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_create_discoverer/](https://www.paws-r-sdk.com/docs/schemas_create_discoverer/) for full documentation.
#'
#' @param Description A description for the discoverer.
#' @param SourceArn &#91;required&#93; The ARN of the event bus.
#' @param CrossAccount Support discovery of schemas in events sent to the bus from another
#' account. (default: true).
#' @param Tags Tags associated with the resource.
#'
#' @keywords internal
#'
#' @rdname schemas_create_discoverer
schemas_create_discoverer <- function(Description = NULL, SourceArn, CrossAccount = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDiscoverer",
    http_method = "POST",
    http_path = "/v1/discoverers",
    paginator = list()
  )
  input <- .schemas$create_discoverer_input(Description = Description, SourceArn = SourceArn, CrossAccount = CrossAccount, Tags = Tags)
  output <- .schemas$create_discoverer_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$create_discoverer <- schemas_create_discoverer

#' Creates a registry
#'
#' @description
#' Creates a registry.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_create_registry/](https://www.paws-r-sdk.com/docs/schemas_create_registry/) for full documentation.
#'
#' @param Description A description of the registry to be created.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param Tags Tags to associate with the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_create_registry
schemas_create_registry <- function(Description = NULL, RegistryName, Tags = NULL) {
  op <- new_operation(
    name = "CreateRegistry",
    http_method = "POST",
    http_path = "/v1/registries/name/{registryName}",
    paginator = list()
  )
  input <- .schemas$create_registry_input(Description = Description, RegistryName = RegistryName, Tags = Tags)
  output <- .schemas$create_registry_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$create_registry <- schemas_create_registry

#' Creates a schema definition
#'
#' @description
#' Creates a schema definition.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_create_schema/](https://www.paws-r-sdk.com/docs/schemas_create_schema/) for full documentation.
#'
#' @param Content &#91;required&#93; The source of the schema definition.
#' @param Description A description of the schema.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param Tags Tags associated with the schema.
#' @param Type &#91;required&#93; The type of schema.
#'
#' @keywords internal
#'
#' @rdname schemas_create_schema
schemas_create_schema <- function(Content, Description = NULL, RegistryName, SchemaName, Tags = NULL, Type) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "POST",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
    paginator = list()
  )
  input <- .schemas$create_schema_input(Content = Content, Description = Description, RegistryName = RegistryName, SchemaName = SchemaName, Tags = Tags, Type = Type)
  output <- .schemas$create_schema_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$create_schema <- schemas_create_schema

#' Deletes a discoverer
#'
#' @description
#' Deletes a discoverer.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_delete_discoverer/](https://www.paws-r-sdk.com/docs/schemas_delete_discoverer/) for full documentation.
#'
#' @param DiscovererId &#91;required&#93; The ID of the discoverer.
#'
#' @keywords internal
#'
#' @rdname schemas_delete_discoverer
schemas_delete_discoverer <- function(DiscovererId) {
  op <- new_operation(
    name = "DeleteDiscoverer",
    http_method = "DELETE",
    http_path = "/v1/discoverers/id/{discovererId}",
    paginator = list()
  )
  input <- .schemas$delete_discoverer_input(DiscovererId = DiscovererId)
  output <- .schemas$delete_discoverer_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$delete_discoverer <- schemas_delete_discoverer

#' Deletes a Registry
#'
#' @description
#' Deletes a Registry.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_delete_registry/](https://www.paws-r-sdk.com/docs/schemas_delete_registry/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; The name of the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_delete_registry
schemas_delete_registry <- function(RegistryName) {
  op <- new_operation(
    name = "DeleteRegistry",
    http_method = "DELETE",
    http_path = "/v1/registries/name/{registryName}",
    paginator = list()
  )
  input <- .schemas$delete_registry_input(RegistryName = RegistryName)
  output <- .schemas$delete_registry_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$delete_registry <- schemas_delete_registry

#' Delete the resource-based policy attached to the specified registry
#'
#' @description
#' Delete the resource-based policy attached to the specified registry.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_delete_resource_policy/](https://www.paws-r-sdk.com/docs/schemas_delete_resource_policy/) for full documentation.
#'
#' @param RegistryName The name of the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_delete_resource_policy
schemas_delete_resource_policy <- function(RegistryName = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "DELETE",
    http_path = "/v1/policy",
    paginator = list()
  )
  input <- .schemas$delete_resource_policy_input(RegistryName = RegistryName)
  output <- .schemas$delete_resource_policy_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$delete_resource_policy <- schemas_delete_resource_policy

#' Delete a schema definition
#'
#' @description
#' Delete a schema definition.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_delete_schema/](https://www.paws-r-sdk.com/docs/schemas_delete_schema/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#'
#' @keywords internal
#'
#' @rdname schemas_delete_schema
schemas_delete_schema <- function(RegistryName, SchemaName) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "DELETE",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
    paginator = list()
  )
  input <- .schemas$delete_schema_input(RegistryName = RegistryName, SchemaName = SchemaName)
  output <- .schemas$delete_schema_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$delete_schema <- schemas_delete_schema

#' Delete the schema version definition
#'
#' @description
#' Delete the schema version definition
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_delete_schema_version/](https://www.paws-r-sdk.com/docs/schemas_delete_schema_version/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param SchemaVersion &#91;required&#93; The version number of the schema
#'
#' @keywords internal
#'
#' @rdname schemas_delete_schema_version
schemas_delete_schema_version <- function(RegistryName, SchemaName, SchemaVersion) {
  op <- new_operation(
    name = "DeleteSchemaVersion",
    http_method = "DELETE",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}/version/{schemaVersion}",
    paginator = list()
  )
  input <- .schemas$delete_schema_version_input(RegistryName = RegistryName, SchemaName = SchemaName, SchemaVersion = SchemaVersion)
  output <- .schemas$delete_schema_version_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$delete_schema_version <- schemas_delete_schema_version

#' Describe the code binding URI
#'
#' @description
#' Describe the code binding URI.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_describe_code_binding/](https://www.paws-r-sdk.com/docs/schemas_describe_code_binding/) for full documentation.
#'
#' @param Language &#91;required&#93; The language of the code binding.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param SchemaVersion Specifying this limits the results to only this schema version.
#'
#' @keywords internal
#'
#' @rdname schemas_describe_code_binding
schemas_describe_code_binding <- function(Language, RegistryName, SchemaName, SchemaVersion = NULL) {
  op <- new_operation(
    name = "DescribeCodeBinding",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}/language/{language}",
    paginator = list()
  )
  input <- .schemas$describe_code_binding_input(Language = Language, RegistryName = RegistryName, SchemaName = SchemaName, SchemaVersion = SchemaVersion)
  output <- .schemas$describe_code_binding_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$describe_code_binding <- schemas_describe_code_binding

#' Describes the discoverer
#'
#' @description
#' Describes the discoverer.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_describe_discoverer/](https://www.paws-r-sdk.com/docs/schemas_describe_discoverer/) for full documentation.
#'
#' @param DiscovererId &#91;required&#93; The ID of the discoverer.
#'
#' @keywords internal
#'
#' @rdname schemas_describe_discoverer
schemas_describe_discoverer <- function(DiscovererId) {
  op <- new_operation(
    name = "DescribeDiscoverer",
    http_method = "GET",
    http_path = "/v1/discoverers/id/{discovererId}",
    paginator = list()
  )
  input <- .schemas$describe_discoverer_input(DiscovererId = DiscovererId)
  output <- .schemas$describe_discoverer_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$describe_discoverer <- schemas_describe_discoverer

#' Describes the registry
#'
#' @description
#' Describes the registry.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_describe_registry/](https://www.paws-r-sdk.com/docs/schemas_describe_registry/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; The name of the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_describe_registry
schemas_describe_registry <- function(RegistryName) {
  op <- new_operation(
    name = "DescribeRegistry",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}",
    paginator = list()
  )
  input <- .schemas$describe_registry_input(RegistryName = RegistryName)
  output <- .schemas$describe_registry_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$describe_registry <- schemas_describe_registry

#' Retrieve the schema definition
#'
#' @description
#' Retrieve the schema definition.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_describe_schema/](https://www.paws-r-sdk.com/docs/schemas_describe_schema/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param SchemaVersion Specifying this limits the results to only this schema version.
#'
#' @keywords internal
#'
#' @rdname schemas_describe_schema
schemas_describe_schema <- function(RegistryName, SchemaName, SchemaVersion = NULL) {
  op <- new_operation(
    name = "DescribeSchema",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
    paginator = list()
  )
  input <- .schemas$describe_schema_input(RegistryName = RegistryName, SchemaName = SchemaName, SchemaVersion = SchemaVersion)
  output <- .schemas$describe_schema_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$describe_schema <- schemas_describe_schema

#' Export schema
#'
#' @description
#' Export schema
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_export_schema/](https://www.paws-r-sdk.com/docs/schemas_export_schema/) for full documentation.
#'
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param SchemaVersion Specifying this limits the results to only this schema version.
#' @param Type &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname schemas_export_schema
schemas_export_schema <- function(RegistryName, SchemaName, SchemaVersion = NULL, Type) {
  op <- new_operation(
    name = "ExportSchema",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}/export",
    paginator = list()
  )
  input <- .schemas$export_schema_input(RegistryName = RegistryName, SchemaName = SchemaName, SchemaVersion = SchemaVersion, Type = Type)
  output <- .schemas$export_schema_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$export_schema <- schemas_export_schema

#' Get the code binding source URI
#'
#' @description
#' Get the code binding source URI.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_get_code_binding_source/](https://www.paws-r-sdk.com/docs/schemas_get_code_binding_source/) for full documentation.
#'
#' @param Language &#91;required&#93; The language of the code binding.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param SchemaVersion Specifying this limits the results to only this schema version.
#'
#' @keywords internal
#'
#' @rdname schemas_get_code_binding_source
schemas_get_code_binding_source <- function(Language, RegistryName, SchemaName, SchemaVersion = NULL) {
  op <- new_operation(
    name = "GetCodeBindingSource",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}/language/{language}/source",
    paginator = list()
  )
  input <- .schemas$get_code_binding_source_input(Language = Language, RegistryName = RegistryName, SchemaName = SchemaName, SchemaVersion = SchemaVersion)
  output <- .schemas$get_code_binding_source_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$get_code_binding_source <- schemas_get_code_binding_source

#' Get the discovered schema that was generated based on sampled events
#'
#' @description
#' Get the discovered schema that was generated based on sampled events.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_get_discovered_schema/](https://www.paws-r-sdk.com/docs/schemas_get_discovered_schema/) for full documentation.
#'
#' @param Events &#91;required&#93; An array of strings where each string is a JSON event. These are the
#' events that were used to generate the schema. The array includes a
#' single type of event and has a maximum size of 10 events.
#' @param Type &#91;required&#93; The type of event.
#'
#' @keywords internal
#'
#' @rdname schemas_get_discovered_schema
schemas_get_discovered_schema <- function(Events, Type) {
  op <- new_operation(
    name = "GetDiscoveredSchema",
    http_method = "POST",
    http_path = "/v1/discover",
    paginator = list()
  )
  input <- .schemas$get_discovered_schema_input(Events = Events, Type = Type)
  output <- .schemas$get_discovered_schema_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$get_discovered_schema <- schemas_get_discovered_schema

#' Retrieves the resource-based policy attached to a given registry
#'
#' @description
#' Retrieves the resource-based policy attached to a given registry.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_get_resource_policy/](https://www.paws-r-sdk.com/docs/schemas_get_resource_policy/) for full documentation.
#'
#' @param RegistryName The name of the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_get_resource_policy
schemas_get_resource_policy <- function(RegistryName = NULL) {
  op <- new_operation(
    name = "GetResourcePolicy",
    http_method = "GET",
    http_path = "/v1/policy",
    paginator = list()
  )
  input <- .schemas$get_resource_policy_input(RegistryName = RegistryName)
  output <- .schemas$get_resource_policy_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$get_resource_policy <- schemas_get_resource_policy

#' List the discoverers
#'
#' @description
#' List the discoverers.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_list_discoverers/](https://www.paws-r-sdk.com/docs/schemas_list_discoverers/) for full documentation.
#'
#' @param DiscovererIdPrefix Specifying this limits the results to only those discoverer IDs that
#' start with the specified prefix.
#' @param Limit 
#' @param NextToken The token that specifies the next page of results to return. To request
#' the first page, leave NextToken empty. The token will expire in 24
#' hours, and cannot be shared with other accounts.
#' @param SourceArnPrefix Specifying this limits the results to only those ARNs that start with
#' the specified prefix.
#'
#' @keywords internal
#'
#' @rdname schemas_list_discoverers
schemas_list_discoverers <- function(DiscovererIdPrefix = NULL, Limit = NULL, NextToken = NULL, SourceArnPrefix = NULL) {
  op <- new_operation(
    name = "ListDiscoverers",
    http_method = "GET",
    http_path = "/v1/discoverers",
    paginator = list()
  )
  input <- .schemas$list_discoverers_input(DiscovererIdPrefix = DiscovererIdPrefix, Limit = Limit, NextToken = NextToken, SourceArnPrefix = SourceArnPrefix)
  output <- .schemas$list_discoverers_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$list_discoverers <- schemas_list_discoverers

#' List the registries
#'
#' @description
#' List the registries.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_list_registries/](https://www.paws-r-sdk.com/docs/schemas_list_registries/) for full documentation.
#'
#' @param Limit 
#' @param NextToken The token that specifies the next page of results to return. To request
#' the first page, leave NextToken empty. The token will expire in 24
#' hours, and cannot be shared with other accounts.
#' @param RegistryNamePrefix Specifying this limits the results to only those registry names that
#' start with the specified prefix.
#' @param Scope Can be set to Local or AWS to limit responses to your custom registries,
#' or the ones provided by AWS.
#'
#' @keywords internal
#'
#' @rdname schemas_list_registries
schemas_list_registries <- function(Limit = NULL, NextToken = NULL, RegistryNamePrefix = NULL, Scope = NULL) {
  op <- new_operation(
    name = "ListRegistries",
    http_method = "GET",
    http_path = "/v1/registries",
    paginator = list()
  )
  input <- .schemas$list_registries_input(Limit = Limit, NextToken = NextToken, RegistryNamePrefix = RegistryNamePrefix, Scope = Scope)
  output <- .schemas$list_registries_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$list_registries <- schemas_list_registries

#' Provides a list of the schema versions and related information
#'
#' @description
#' Provides a list of the schema versions and related information.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_list_schema_versions/](https://www.paws-r-sdk.com/docs/schemas_list_schema_versions/) for full documentation.
#'
#' @param Limit 
#' @param NextToken The token that specifies the next page of results to return. To request
#' the first page, leave NextToken empty. The token will expire in 24
#' hours, and cannot be shared with other accounts.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#'
#' @keywords internal
#'
#' @rdname schemas_list_schema_versions
schemas_list_schema_versions <- function(Limit = NULL, NextToken = NULL, RegistryName, SchemaName) {
  op <- new_operation(
    name = "ListSchemaVersions",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}/versions",
    paginator = list()
  )
  input <- .schemas$list_schema_versions_input(Limit = Limit, NextToken = NextToken, RegistryName = RegistryName, SchemaName = SchemaName)
  output <- .schemas$list_schema_versions_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$list_schema_versions <- schemas_list_schema_versions

#' List the schemas
#'
#' @description
#' List the schemas.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_list_schemas/](https://www.paws-r-sdk.com/docs/schemas_list_schemas/) for full documentation.
#'
#' @param Limit 
#' @param NextToken The token that specifies the next page of results to return. To request
#' the first page, leave NextToken empty. The token will expire in 24
#' hours, and cannot be shared with other accounts.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaNamePrefix Specifying this limits the results to only those schema names that start
#' with the specified prefix.
#'
#' @keywords internal
#'
#' @rdname schemas_list_schemas
schemas_list_schemas <- function(Limit = NULL, NextToken = NULL, RegistryName, SchemaNamePrefix = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas",
    paginator = list()
  )
  input <- .schemas$list_schemas_input(Limit = Limit, NextToken = NextToken, RegistryName = RegistryName, SchemaNamePrefix = SchemaNamePrefix)
  output <- .schemas$list_schemas_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$list_schemas <- schemas_list_schemas

#' Get tags for resource
#'
#' @description
#' Get tags for resource.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/schemas_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname schemas_list_tags_for_resource
schemas_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resource-arn}",
    paginator = list()
  )
  input <- .schemas$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .schemas$list_tags_for_resource_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$list_tags_for_resource <- schemas_list_tags_for_resource

#' Put code binding URI
#'
#' @description
#' Put code binding URI
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_put_code_binding/](https://www.paws-r-sdk.com/docs/schemas_put_code_binding/) for full documentation.
#'
#' @param Language &#91;required&#93; The language of the code binding.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param SchemaVersion Specifying this limits the results to only this schema version.
#'
#' @keywords internal
#'
#' @rdname schemas_put_code_binding
schemas_put_code_binding <- function(Language, RegistryName, SchemaName, SchemaVersion = NULL) {
  op <- new_operation(
    name = "PutCodeBinding",
    http_method = "POST",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}/language/{language}",
    paginator = list()
  )
  input <- .schemas$put_code_binding_input(Language = Language, RegistryName = RegistryName, SchemaName = SchemaName, SchemaVersion = SchemaVersion)
  output <- .schemas$put_code_binding_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$put_code_binding <- schemas_put_code_binding

#' The name of the policy
#'
#' @description
#' The name of the policy.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_put_resource_policy/](https://www.paws-r-sdk.com/docs/schemas_put_resource_policy/) for full documentation.
#'
#' @param Policy &#91;required&#93; The resource-based policy.
#' @param RegistryName The name of the registry.
#' @param RevisionId The revision ID of the policy.
#'
#' @keywords internal
#'
#' @rdname schemas_put_resource_policy
schemas_put_resource_policy <- function(Policy, RegistryName = NULL, RevisionId = NULL) {
  op <- new_operation(
    name = "PutResourcePolicy",
    http_method = "PUT",
    http_path = "/v1/policy",
    paginator = list()
  )
  input <- .schemas$put_resource_policy_input(Policy = Policy, RegistryName = RegistryName, RevisionId = RevisionId)
  output <- .schemas$put_resource_policy_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$put_resource_policy <- schemas_put_resource_policy

#' Search the schemas
#'
#' @description
#' Search the schemas
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_search_schemas/](https://www.paws-r-sdk.com/docs/schemas_search_schemas/) for full documentation.
#'
#' @param Keywords &#91;required&#93; Specifying this limits the results to only schemas that include the
#' provided keywords.
#' @param Limit 
#' @param NextToken The token that specifies the next page of results to return. To request
#' the first page, leave NextToken empty. The token will expire in 24
#' hours, and cannot be shared with other accounts.
#' @param RegistryName &#91;required&#93; The name of the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_search_schemas
schemas_search_schemas <- function(Keywords, Limit = NULL, NextToken = NULL, RegistryName) {
  op <- new_operation(
    name = "SearchSchemas",
    http_method = "GET",
    http_path = "/v1/registries/name/{registryName}/schemas/search",
    paginator = list()
  )
  input <- .schemas$search_schemas_input(Keywords = Keywords, Limit = Limit, NextToken = NextToken, RegistryName = RegistryName)
  output <- .schemas$search_schemas_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$search_schemas <- schemas_search_schemas

#' Starts the discoverer
#'
#' @description
#' Starts the discoverer
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_start_discoverer/](https://www.paws-r-sdk.com/docs/schemas_start_discoverer/) for full documentation.
#'
#' @param DiscovererId &#91;required&#93; The ID of the discoverer.
#'
#' @keywords internal
#'
#' @rdname schemas_start_discoverer
schemas_start_discoverer <- function(DiscovererId) {
  op <- new_operation(
    name = "StartDiscoverer",
    http_method = "POST",
    http_path = "/v1/discoverers/id/{discovererId}/start",
    paginator = list()
  )
  input <- .schemas$start_discoverer_input(DiscovererId = DiscovererId)
  output <- .schemas$start_discoverer_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$start_discoverer <- schemas_start_discoverer

#' Stops the discoverer
#'
#' @description
#' Stops the discoverer
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_stop_discoverer/](https://www.paws-r-sdk.com/docs/schemas_stop_discoverer/) for full documentation.
#'
#' @param DiscovererId &#91;required&#93; The ID of the discoverer.
#'
#' @keywords internal
#'
#' @rdname schemas_stop_discoverer
schemas_stop_discoverer <- function(DiscovererId) {
  op <- new_operation(
    name = "StopDiscoverer",
    http_method = "POST",
    http_path = "/v1/discoverers/id/{discovererId}/stop",
    paginator = list()
  )
  input <- .schemas$stop_discoverer_input(DiscovererId = DiscovererId)
  output <- .schemas$stop_discoverer_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$stop_discoverer <- schemas_stop_discoverer

#' Add tags to a resource
#'
#' @description
#' Add tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_tag_resource/](https://www.paws-r-sdk.com/docs/schemas_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource.
#' @param Tags &#91;required&#93; Tags associated with the resource.
#'
#' @keywords internal
#'
#' @rdname schemas_tag_resource
schemas_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resource-arn}",
    paginator = list()
  )
  input <- .schemas$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .schemas$tag_resource_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$tag_resource <- schemas_tag_resource

#' Removes tags from a resource
#'
#' @description
#' Removes tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_untag_resource/](https://www.paws-r-sdk.com/docs/schemas_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the resource.
#' @param TagKeys &#91;required&#93; Keys of key-value pairs.
#'
#' @keywords internal
#'
#' @rdname schemas_untag_resource
schemas_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resource-arn}",
    paginator = list()
  )
  input <- .schemas$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .schemas$untag_resource_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$untag_resource <- schemas_untag_resource

#' Updates the discoverer
#'
#' @description
#' Updates the discoverer
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_update_discoverer/](https://www.paws-r-sdk.com/docs/schemas_update_discoverer/) for full documentation.
#'
#' @param Description The description of the discoverer to update.
#' @param DiscovererId &#91;required&#93; The ID of the discoverer.
#' @param CrossAccount Support discovery of schemas in events sent to the bus from another
#' account. (default: true)
#'
#' @keywords internal
#'
#' @rdname schemas_update_discoverer
schemas_update_discoverer <- function(Description = NULL, DiscovererId, CrossAccount = NULL) {
  op <- new_operation(
    name = "UpdateDiscoverer",
    http_method = "PUT",
    http_path = "/v1/discoverers/id/{discovererId}",
    paginator = list()
  )
  input <- .schemas$update_discoverer_input(Description = Description, DiscovererId = DiscovererId, CrossAccount = CrossAccount)
  output <- .schemas$update_discoverer_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$update_discoverer <- schemas_update_discoverer

#' Updates a registry
#'
#' @description
#' Updates a registry.
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_update_registry/](https://www.paws-r-sdk.com/docs/schemas_update_registry/) for full documentation.
#'
#' @param Description The description of the registry to update.
#' @param RegistryName &#91;required&#93; The name of the registry.
#'
#' @keywords internal
#'
#' @rdname schemas_update_registry
schemas_update_registry <- function(Description = NULL, RegistryName) {
  op <- new_operation(
    name = "UpdateRegistry",
    http_method = "PUT",
    http_path = "/v1/registries/name/{registryName}",
    paginator = list()
  )
  input <- .schemas$update_registry_input(Description = Description, RegistryName = RegistryName)
  output <- .schemas$update_registry_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$update_registry <- schemas_update_registry

#' Updates the schema definition
#'
#' @description
#' Updates the schema definition
#'
#' See [https://www.paws-r-sdk.com/docs/schemas_update_schema/](https://www.paws-r-sdk.com/docs/schemas_update_schema/) for full documentation.
#'
#' @param ClientTokenId The ID of the client token.
#' @param Content The source of the schema definition.
#' @param Description The description of the schema.
#' @param RegistryName &#91;required&#93; The name of the registry.
#' @param SchemaName &#91;required&#93; The name of the schema.
#' @param Type The schema type for the events schema.
#'
#' @keywords internal
#'
#' @rdname schemas_update_schema
schemas_update_schema <- function(ClientTokenId = NULL, Content = NULL, Description = NULL, RegistryName, SchemaName, Type = NULL) {
  op <- new_operation(
    name = "UpdateSchema",
    http_method = "PUT",
    http_path = "/v1/registries/name/{registryName}/schemas/name/{schemaName}",
    paginator = list()
  )
  input <- .schemas$update_schema_input(ClientTokenId = ClientTokenId, Content = Content, Description = Description, RegistryName = RegistryName, SchemaName = SchemaName, Type = Type)
  output <- .schemas$update_schema_output()
  config <- get_config()
  svc <- .schemas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.schemas$operations$update_schema <- schemas_update_schema
