% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swf_operations.R
\name{swf_poll_for_activity_task}
\alias{swf_poll_for_activity_task}
\title{Used by workers to get an ActivityTask from the specified activity
taskList}
\usage{
swf_poll_for_activity_task(domain, taskList, identity = NULL)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the task lists being polled.}

\item{taskList}{[required] Specifies the task list to poll for activity tasks.

The specified string must not start or end with whitespace. It must not
contain a \code{:} (colon), \code{/} (slash), \code{|} (vertical bar), or any control
characters (\verb{U+0000`-`U+001f} | \verb{U+007f`-`U+009f}). Also, it must not \emph{be}
the literal string \code{arn}.}

\item{identity}{Identity of the worker making the request, recorded in the
\code{ActivityTaskStarted} event in the workflow history. This enables
diagnostic tracing when problems arise. The form of this identity is
user defined.}
}
\description{
Used by workers to get an ActivityTask from the specified activity \code{taskList}. This initiates a long poll, where the service holds the HTTP connection open and responds as soon as a task becomes available. The maximum time the service holds on to the request before responding is 60 seconds. If no task is available within 60 seconds, the poll returns an empty result. An empty result, in this context, means that an ActivityTask is returned, but that the value of taskToken is an empty string. If a task is returned, the worker should use its type to identify and process it correctly.

See \url{https://paws-r.github.io/docs/swf/poll_for_activity_task.html} for full documentation.
}
\keyword{internal}
