% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_create_archive}
\alias{eventbridge_create_archive}
\title{Creates an archive of events with the specified settings}
\usage{
eventbridge_create_archive(ArchiveName, EventSourceArn, Description,
  EventPattern, RetentionDays)
}
\arguments{
\item{ArchiveName}{[required] The name for the archive to create.}

\item{EventSourceArn}{[required] The ARN of the event source associated with the archive.}

\item{Description}{A description for the archive.}

\item{EventPattern}{An event pattern to use to filter events sent to the archive.}

\item{RetentionDays}{The number of days to retain events for. Default value is 0. If set to
0, events are retained indefinitely}
}
\value{
A list with the following syntax:\preformatted{list(
  ArchiveArn = "string",
  State = "ENABLED"|"DISABLED"|"CREATING"|"UPDATING"|"CREATE_FAILED"|"UPDATE_FAILED",
  StateReason = "string",
  CreationTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Creates an archive of events with the specified settings. When you
create an archive, incoming events might not immediately start being
sent to the archive. Allow a short period of time for changes to take
effect. If you do not specify a pattern to filter events sent to the
archive, all events are sent to the archive except replayed events.
Replayed events are not sent to an archive.
}
\section{Request syntax}{
\preformatted{svc$create_archive(
  ArchiveName = "string",
  EventSourceArn = "string",
  Description = "string",
  EventPattern = "string",
  RetentionDays = 123
)
}
}

\keyword{internal}
