% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_update_scheduled_action}
\alias{opensearchservice_update_scheduled_action}
\title{Reschedules a planned domain configuration change for a later time}
\usage{
opensearchservice_update_scheduled_action(
  DomainName,
  ActionID,
  ActionType,
  ScheduleAt,
  DesiredStartTime = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain to reschedule an action for.}

\item{ActionID}{[required] The unique identifier of the action to reschedule. To retrieve this ID,
send a
\code{\link[=opensearchservice_list_scheduled_actions]{list_scheduled_actions}}
request.}

\item{ActionType}{[required] The type of action to reschedule. Can be one of
\code{SERVICE_SOFTWARE_UPDATE}, \code{JVM_HEAP_SIZE_TUNING}, or
\code{JVM_YOUNG_GEN_TUNING}. To retrieve this value, send a
\code{\link[=opensearchservice_list_scheduled_actions]{list_scheduled_actions}}
request.}

\item{ScheduleAt}{[required] When to schedule the action.
\itemize{
\item \code{NOW} - Immediately schedules the update to happen in the current
hour if there's capacity available.
\item \code{TIMESTAMP} - Lets you specify a custom date and time to apply the
update. If you specify this value, you must also provide a value for
\code{DesiredStartTime}.
\item \code{OFF_PEAK_WINDOW} - Marks the action to be picked up during an
upcoming off-peak window. There's no guarantee that the change will
be implemented during the next immediate window. Depending on
capacity, it might happen in subsequent days.
}}

\item{DesiredStartTime}{The time to implement the change, in Coordinated Universal Time (UTC).
Only specify this parameter if you set \code{ScheduleAt} to \code{TIMESTAMP}.}
}
\description{
Reschedules a planned domain configuration change for a later time. This change can be a scheduled \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html}{service software update} or a \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types}{blue/green Auto-Tune enhancement}.

See \url{https://www.paws-r-sdk.com/docs/opensearchservice_update_scheduled_action/} for full documentation.
}
\keyword{internal}
