% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchservice_operations.R
\name{opensearchservice_dissociate_package}
\alias{opensearchservice_dissociate_package}
\title{Removes a package from the specified Amazon OpenSearch Service domain}
\usage{
opensearchservice_dissociate_package(PackageID, DomainName)
}
\arguments{
\item{PackageID}{[required] Internal ID of the package to dissociate from the domain. Use
\code{\link[=opensearchservice_list_packages_for_domain]{list_packages_for_domain}}
to find this value.}

\item{DomainName}{[required] Name of the domain to dissociate the package from.}
}
\description{
Removes a package from the specified Amazon OpenSearch Service domain. The package can't be in use with any OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for association later. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html}{Custom packages for Amazon OpenSearch Service}.

See \url{https://www.paws-r-sdk.com/docs/opensearchservice_dissociate_package/} for full documentation.
}
\keyword{internal}
