% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_environment_actions}
\alias{datazone_list_environment_actions}
\title{Lists existing environment actions}
\usage{
datazone_list_environment_actions(
  domainIdentifier,
  environmentIdentifier,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{domainIdentifier}{[required] The ID of the Amazon DataZone domain in which the environment actions
are listed.}

\item{environmentIdentifier}{[required] The ID of the envrironment whose environment actions are listed.}

\item{maxResults}{The maximum number of environment actions to return in a single call to
\code{\link[=datazone_list_environment_actions]{list_environment_actions}}. When
the number of environment actions to be listed is greater than the value
of \code{MaxResults}, the response contains a \code{NextToken} value that you can
use in a subsequent call to
\code{\link[=datazone_list_environment_actions]{list_environment_actions}} to list
the next set of environment actions.}

\item{nextToken}{When the number of environment actions is greater than the default value
for the \code{MaxResults} parameter, or if you explicitly specify a value for
\code{MaxResults} that is less than the number of environment actions, the
response includes a pagination token named \code{NextToken}. You can specify
this \code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_environment_actions]{list_environment_actions}} to list
the next set of environment actions.}
}
\description{
Lists existing environment actions.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_environment_actions/} for full documentation.
}
\keyword{internal}
