% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_create_stream}
\alias{kinesis_create_stream}
\title{Creates a Kinesis data stream}
\usage{
kinesis_create_stream(
  StreamName,
  ShardCount = NULL,
  StreamModeDetails = NULL,
  Tags = NULL
)
}
\arguments{
\item{StreamName}{[required] A name to identify the stream. The stream name is scoped to the Amazon
Web Services account used by the application that creates the stream. It
is also scoped by Amazon Web Services Region. That is, two streams in
two different Amazon Web Services accounts can have the same name. Two
streams in the same Amazon Web Services account but in two different
Regions can also have the same name.}

\item{ShardCount}{The number of shards that the stream will use. The throughput of the
stream is a function of the number of shards; more shards are required
for greater provisioned throughput.}

\item{StreamModeDetails}{Indicates the capacity mode of the data stream. Currently, in Kinesis
Data Streams, you can choose between an \strong{on-demand} capacity mode and
a \strong{provisioned} capacity mode for your data streams.}

\item{Tags}{A set of up to 10 key-value pairs to use to create the tags.}
}
\description{
Creates a Kinesis data stream. A stream captures and transports data records that are continuously emitted from different data sources or \emph{producers}. Scale-out within a stream is explicitly supported by means of shards, which are uniquely identified groups of data records in a stream.

See \url{https://www.paws-r-sdk.com/docs/kinesis_create_stream/} for full documentation.
}
\keyword{internal}
