% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_register_schema_version}
\alias{glue_register_schema_version}
\title{Adds a new version to the existing schema}
\usage{
glue_register_schema_version(SchemaId, SchemaDefinition)
}
\arguments{
\item{SchemaId}{[required] This is a wrapper structure to contain schema identity fields. The
structure contains:
\itemize{
\item SchemaId$SchemaArn: The Amazon Resource Name (ARN) of the schema.
Either \code{SchemaArn} or \code{SchemaName} and \code{RegistryName} has to be
provided.
\item SchemaId$SchemaName: The name of the schema. Either \code{SchemaArn} or
\code{SchemaName} and \code{RegistryName} has to be provided.
}}

\item{SchemaDefinition}{[required] The schema definition using the \code{DataFormat} setting for the
\code{SchemaName}.}
}
\description{
Adds a new version to the existing schema. Returns an error if new version of schema does not meet the compatibility requirements of the schema set. This API will not create a new schema set and will return a 404 error if the schema set is not already present in the Schema Registry.

See \url{https://www.paws-r-sdk.com/docs/glue_register_schema_version/} for full documentation.
}
\keyword{internal}
