% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_list_table_optimizer_runs}
\alias{glue_list_table_optimizer_runs}
\title{Lists the history of previous optimizer runs for a specific table}
\usage{
glue_list_table_optimizer_runs(
  CatalogId,
  DatabaseName,
  TableName,
  Type,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{CatalogId}{[required] The Catalog ID of the table.}

\item{DatabaseName}{[required] The name of the database in the catalog in which the table resides.}

\item{TableName}{[required] The name of the table.}

\item{Type}{[required] The type of table optimizer.}

\item{MaxResults}{The maximum number of optimizer runs to return on each call.}

\item{NextToken}{A continuation token, if this is a continuation call.}
}
\description{
Lists the history of previous optimizer runs for a specific table.

See \url{https://www.paws-r-sdk.com/docs/glue_list_table_optimizer_runs/} for full documentation.
}
\keyword{internal}
