% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_list_subscription_requests}
\alias{datazone_list_subscription_requests}
\title{Lists Amazon DataZone subscription requests}
\usage{
datazone_list_subscription_requests(
  approverProjectId = NULL,
  domainIdentifier,
  maxResults = NULL,
  nextToken = NULL,
  owningProjectId = NULL,
  sortBy = NULL,
  sortOrder = NULL,
  status = NULL,
  subscribedListingId = NULL
)
}
\arguments{
\item{approverProjectId}{The identifier of the subscription request approver's project.}

\item{domainIdentifier}{[required] The identifier of the Amazon DataZone domain.}

\item{maxResults}{The maximum number of subscription requests to return in a single call
to \code{\link[=datazone_list_subscription_requests]{list_subscription_requests}}.
When the number of subscription requests to be listed is greater than
the value of \code{MaxResults}, the response contains a \code{NextToken} value
that you can use in a subsequent call to
\code{\link[=datazone_list_subscription_requests]{list_subscription_requests}} to
list the next set of subscription requests.}

\item{nextToken}{When the number of subscription requests is greater than the default
value for the \code{MaxResults} parameter, or if you explicitly specify a
value for \code{MaxResults} that is less than the number of subscription
requests, the response includes a pagination token named \code{NextToken}.
You can specify this \code{NextToken} value in a subsequent call to
\code{\link[=datazone_list_subscription_requests]{list_subscription_requests}} to
list the next set of subscription requests.}

\item{owningProjectId}{The identifier of the project for the subscription requests.}

\item{sortBy}{Specifies the way to sort the results of this action.}

\item{sortOrder}{Specifies the sort order for the results of this action.}

\item{status}{Specifies the status of the subscription requests.

This is not a required parameter, but if not specified, by default,
Amazon DataZone returns only \code{PENDING} subscription requests.}

\item{subscribedListingId}{The identifier of the subscribed listing.}
}
\description{
Lists Amazon DataZone subscription requests.

See \url{https://www.paws-r-sdk.com/docs/datazone_list_subscription_requests/} for full documentation.
}
\keyword{internal}
