% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entityresolution_operations.R
\name{entityresolution_create_id_namespace}
\alias{entityresolution_create_id_namespace}
\title{Creates an ID namespace object which will help customers provide
metadata explaining their dataset and how to use it}
\usage{
entityresolution_create_id_namespace(
  description = NULL,
  idMappingWorkflowProperties = NULL,
  idNamespaceName,
  inputSourceConfig = NULL,
  roleArn = NULL,
  tags = NULL,
  type
)
}
\arguments{
\item{description}{The description of the ID namespace.}

\item{idMappingWorkflowProperties}{Determines the properties of \code{IdMappingWorflow} where this \code{IdNamespace}
can be used as a \code{Source} or a \code{Target}.}

\item{idNamespaceName}{[required] The name of the ID namespace.}

\item{inputSourceConfig}{A list of \code{InputSource} objects, which have the fields \code{InputSourceARN}
and \code{SchemaName}.}

\item{roleArn}{The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
assumes this role to access the resources defined in this \code{IdNamespace}
on your behalf as part of the workflow run.}

\item{tags}{The tags used to organize, track, or control access for this resource.}

\item{type}{[required] The type of ID namespace. There are two types: \code{SOURCE} and \code{TARGET}.

The \code{SOURCE} contains configurations for \code{sourceId} data that will be
processed in an ID mapping workflow.

The \code{TARGET} contains a configuration of \code{targetId} to which all
\code{sourceIds} will resolve to.}
}
\description{
Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use it. Each ID namespace must have a unique name. To modify an existing ID namespace, use the \code{\link[=entityresolution_update_id_namespace]{update_id_namespace}} API.

See \url{https://www.paws-r-sdk.com/docs/entityresolution_create_id_namespace/} for full documentation.
}
\keyword{internal}
