% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_update_featured_results_set}
\alias{kendra_update_featured_results_set}
\title{Updates a set of featured results}
\usage{
kendra_update_featured_results_set(
  IndexId,
  FeaturedResultsSetId,
  FeaturedResultsSetName = NULL,
  Description = NULL,
  Status = NULL,
  QueryTexts = NULL,
  FeaturedDocuments = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index used for featuring results.}

\item{FeaturedResultsSetId}{[required] The identifier of the set of featured results that you want to update.}

\item{FeaturedResultsSetName}{A new name for the set of featured results.}

\item{Description}{A new description for the set of featured results.}

\item{Status}{You can set the status to \code{ACTIVE} or \code{INACTIVE}. When the value is
\code{ACTIVE}, featured results are ready for use. You can still configure
your settings before setting the status to \code{ACTIVE}. The queries you
specify for featured results must be unique per featured results set for
each index, whether the status is \code{ACTIVE} or \code{INACTIVE}.}

\item{QueryTexts}{A list of queries for featuring results. For more information on the
list of queries, see
\href{https://docs.aws.amazon.com/kendra/latest/APIReference/API_FeaturedResultsSet.html}{FeaturedResultsSet}.}

\item{FeaturedDocuments}{A list of document IDs for the documents you want to feature at the top
of the search results page. For more information on the list of featured
documents, see
\href{https://docs.aws.amazon.com/kendra/latest/APIReference/API_FeaturedResultsSet.html}{FeaturedResultsSet}.}
}
\description{
Updates a set of featured results. Features results are placed above all other results for certain queries. You map specific queries to specific documents for featuring in the results. If a query contains an exact match of a query, then one or more specific documents are featured in the search results.

See \url{https://www.paws-r-sdk.com/docs/kendra_update_featured_results_set/} for full documentation.
}
\keyword{internal}
