% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_disable_enhanced_monitoring}
\alias{kinesis_disable_enhanced_monitoring}
\title{Disables enhanced monitoring}
\usage{
kinesis_disable_enhanced_monitoring(StreamName, ShardLevelMetrics)
}
\arguments{
\item{StreamName}{[required] The name of the Kinesis data stream for which to disable enhanced
monitoring.}

\item{ShardLevelMetrics}{[required] List of shard-level metrics to disable.

The following are the valid shard-level metrics. The value "\code{ALL}"
disables every metric.
\itemize{
\item \code{IncomingBytes}
\item \code{IncomingRecords}
\item \code{OutgoingBytes}
\item \code{OutgoingRecords}
\item \code{WriteProvisionedThroughputExceeded}
\item \code{ReadProvisionedThroughputExceeded}
\item \code{IteratorAgeMilliseconds}
\item \code{ALL}
}

For more information, see \href{https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html}{Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch}
in the \emph{Amazon Kinesis Data Streams Developer Guide}.}
}
\description{
Disables enhanced monitoring.

See \url{https://paws-r.github.io/docs/kinesis/disable_enhanced_monitoring.html} for full documentation.
}
\keyword{internal}
