% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_create_thesaurus}
\alias{kendra_create_thesaurus}
\title{Creates a thesaurus for an index}
\usage{
kendra_create_thesaurus(
  IndexId,
  Name,
  Description = NULL,
  RoleArn,
  Tags = NULL,
  SourceS3Path,
  ClientToken = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index for the thesaurus.}

\item{Name}{[required] A name for the thesaurus.}

\item{Description}{A description for the thesaurus.}

\item{RoleArn}{[required] An IAM role that gives Amazon Kendra permissions to access thesaurus
file specified in \code{SourceS3Path}.}

\item{Tags}{A list of key-value pairs that identify the thesaurus. You can use the
tags to identify and organize your resources and to control access to
resources.}

\item{SourceS3Path}{[required] The path to the thesaurus file in S3.}

\item{ClientToken}{A token that you provide to identify the request to create a thesaurus.
Multiple calls to the \code{\link[=kendra_create_thesaurus]{create_thesaurus}} API
with the same client token will create only one thesaurus.}
}
\description{
Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.

See \url{https://paws-r.github.io/docs/kendra/create_thesaurus.html} for full documentation.
}
\keyword{internal}
