% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_associate_personas_to_entities}
\alias{kendra_associate_personas_to_entities}
\title{Defines the specific permissions of users or groups in your Amazon Web
Services SSO identity source with access to your Amazon Kendra
experience}
\usage{
kendra_associate_personas_to_entities(Id, IndexId, Personas)
}
\arguments{
\item{Id}{[required] The identifier of your Amazon Kendra experience.}

\item{IndexId}{[required] The identifier of the index for your Amazon Kendra experience.}

\item{Personas}{[required] The personas that define the specific permissions of users or groups in
your Amazon Web Services SSO identity source. The available personas or
access roles are \code{Owner} and \code{Viewer}. For more information on these
personas, see \href{https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience}{Providing access to your search page}.}
}
\description{
Defines the specific permissions of users or groups in your Amazon Web Services SSO identity source with access to your Amazon Kendra experience. You can create an Amazon Kendra experience such as a search application. For more information on creating a search application experience, see \href{https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html}{Building a search experience with no code}.

See \url{https://paws-r.github.io/docs/kendra/associate_personas_to_entities.html} for full documentation.
}
\keyword{internal}
