# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include opensearchservice_service.R
NULL

#' Allows the remote domain owner to accept an inbound cross-cluster
#' connection request
#'
#' @description
#' Allows the remote domain owner to accept an inbound cross-cluster connection request.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/accept_inbound_connection.html](https://paws-r.github.io/docs/opensearchservice/accept_inbound_connection.html) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the inbound connection you want to accept.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_accept_inbound_connection
opensearchservice_accept_inbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "AcceptInboundConnection",
    http_method = "PUT",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/accept",
    paginator = list()
  )
  input <- .opensearchservice$accept_inbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$accept_inbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$accept_inbound_connection <- opensearchservice_accept_inbound_connection

#' Attaches tags to an existing domain
#'
#' @description
#' Attaches tags to an existing domain. Tags are a set of case-sensitive key value pairs. An domain can have up to 10 tags. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/#managedomains-awsresorcetagging" target="_blank">Tagging Amazon OpenSearch Service domains</a> for more information.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/add_tags.html](https://paws-r.github.io/docs/opensearchservice/add_tags.html) for full documentation.
#'
#' @param ARN &#91;required&#93; Specify the `ARN` of the domain you want to add tags to.
#' @param TagList &#91;required&#93; List of `Tag` to add to the domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_add_tags
opensearchservice_add_tags <- function(ARN, TagList) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/2021-01-01/tags",
    paginator = list()
  )
  input <- .opensearchservice$add_tags_input(ARN = ARN, TagList = TagList)
  output <- .opensearchservice$add_tags_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$add_tags <- opensearchservice_add_tags

#' Associates a package with an Amazon OpenSearch Service domain
#'
#' @description
#' Associates a package with an Amazon OpenSearch Service domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/associate_package.html](https://paws-r.github.io/docs/opensearchservice/associate_package.html) for full documentation.
#'
#' @param PackageID &#91;required&#93; Internal ID of the package to associate with a domain. Use
#' [`describe_packages`][opensearchservice_describe_packages] to find this
#' value.
#' @param DomainName &#91;required&#93; The name of the domain to associate the package with.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_associate_package
opensearchservice_associate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "AssociatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages/associate/{PackageID}/{DomainName}",
    paginator = list()
  )
  input <- .opensearchservice$associate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .opensearchservice$associate_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$associate_package <- opensearchservice_associate_package

#' Cancels a scheduled service software update for an Amazon OpenSearch
#' Service domain
#'
#' @description
#' Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/cancel_service_software_update.html](https://paws-r.github.io/docs/opensearchservice/cancel_service_software_update.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to stop the latest service software
#' update on.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_cancel_service_software_update
opensearchservice_cancel_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "CancelServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/serviceSoftwareUpdate/cancel",
    paginator = list()
  )
  input <- .opensearchservice$cancel_service_software_update_input(DomainName = DomainName)
  output <- .opensearchservice$cancel_service_software_update_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$cancel_service_software_update <- opensearchservice_cancel_service_software_update

#' Creates a new Amazon OpenSearch Service domain
#'
#' @description
#' Creates a new Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html" target="_blank">Creating and managing Amazon OpenSearch Service domains</a> in the *Amazon OpenSearch Service Developer Guide*.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/create_domain.html](https://paws-r.github.io/docs/opensearchservice/create_domain.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the Amazon OpenSearch Service domain you're creating. Domain
#' names are unique across the domains owned by an account within an AWS
#' region. Domain names must start with a lowercase letter and can contain
#' the following characters: a-z (lowercase), 0-9, and - (hyphen).
#' @param EngineVersion String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the
#' engine version for the Amazon OpenSearch Service domain. For example,
#' "OpenSearch_1.0" or "Elasticsearch_7.9". For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains"
#' target="_blank">Creating and managing Amazon OpenSearch Service
#' domains</a> .
#' @param ClusterConfig Configuration options for a domain. Specifies the instance type and
#' number of instances in the domain.
#' @param EBSOptions Options to enable, disable, and specify the type and size of EBS storage
#' volumes.
#' @param AccessPolicies IAM access policy as a JSON-formatted string.
#' @param SnapshotOptions Option to set time, in UTC format, of the daily automated snapshot.
#' Default value is 0 hours.
#' @param VPCOptions Options to specify the subnets and security groups for a VPC endpoint.
#' For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
#' target="_blank">Launching your Amazon OpenSearch Service domains using a
#' VPC</a> .
#' @param CognitoOptions Options to specify the Cognito user and identity pools for OpenSearch
#' Dashboards authentication. For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
#' target="_blank">Configuring Amazon Cognito authentication for OpenSearch
#' Dashboards</a>.
#' @param EncryptionAtRestOptions Options for encryption of data at rest.
#' @param NodeToNodeEncryptionOptions Node-to-node encryption options.
#' @param AdvancedOptions Option to allow references to indices in an HTTP request body. Must be
#' `false` when configuring access to individual sub-resources. By default,
#' the value is `true`. See <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
#' target="_blank">Advanced cluster parameters</a> for more information.
#' @param LogPublishingOptions Map of `LogType` and `LogPublishingOption`, each containing options to
#' publish a given type of OpenSearch log.
#' @param DomainEndpointOptions Options to specify configurations that will be applied to the domain
#' endpoint.
#' @param AdvancedSecurityOptions Specifies advanced security options.
#' @param TagList A list of `Tag` added during domain creation.
#' @param AutoTuneOptions Specifies Auto-Tune options.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_domain
opensearchservice_create_domain <- function(DomainName, EngineVersion = NULL, ClusterConfig = NULL, EBSOptions = NULL, AccessPolicies = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, EncryptionAtRestOptions = NULL, NodeToNodeEncryptionOptions = NULL, AdvancedOptions = NULL, LogPublishingOptions = NULL, DomainEndpointOptions = NULL, AdvancedSecurityOptions = NULL, TagList = NULL, AutoTuneOptions = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain",
    paginator = list()
  )
  input <- .opensearchservice$create_domain_input(DomainName = DomainName, EngineVersion = EngineVersion, ClusterConfig = ClusterConfig, EBSOptions = EBSOptions, AccessPolicies = AccessPolicies, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, AdvancedOptions = AdvancedOptions, LogPublishingOptions = LogPublishingOptions, DomainEndpointOptions = DomainEndpointOptions, AdvancedSecurityOptions = AdvancedSecurityOptions, TagList = TagList, AutoTuneOptions = AutoTuneOptions)
  output <- .opensearchservice$create_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_domain <- opensearchservice_create_domain

#' Creates a new cross-cluster connection from a local OpenSearch domain to
#' a remote OpenSearch domain
#'
#' @description
#' Creates a new cross-cluster connection from a local OpenSearch domain to a remote OpenSearch domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/create_outbound_connection.html](https://paws-r.github.io/docs/opensearchservice/create_outbound_connection.html) for full documentation.
#'
#' @param LocalDomainInfo &#91;required&#93; The ` AWSDomainInformation ` for the local OpenSearch domain.
#' @param RemoteDomainInfo &#91;required&#93; The ` AWSDomainInformation ` for the remote OpenSearch domain.
#' @param ConnectionAlias &#91;required&#93; The connection alias used used by the customer for this cross-cluster
#' connection.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_outbound_connection
opensearchservice_create_outbound_connection <- function(LocalDomainInfo, RemoteDomainInfo, ConnectionAlias) {
  op <- new_operation(
    name = "CreateOutboundConnection",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/cc/outboundConnection",
    paginator = list()
  )
  input <- .opensearchservice$create_outbound_connection_input(LocalDomainInfo = LocalDomainInfo, RemoteDomainInfo = RemoteDomainInfo, ConnectionAlias = ConnectionAlias)
  output <- .opensearchservice$create_outbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_outbound_connection <- opensearchservice_create_outbound_connection

#' Create a package for use with Amazon OpenSearch Service domains
#'
#' @description
#' Create a package for use with Amazon OpenSearch Service domains.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/create_package.html](https://paws-r.github.io/docs/opensearchservice/create_package.html) for full documentation.
#'
#' @param PackageName &#91;required&#93; Unique identifier for the package.
#' @param PackageType &#91;required&#93; Type of package. Currently supports only TXT-DICTIONARY.
#' @param PackageDescription Description of the package.
#' @param PackageSource &#91;required&#93; The Amazon S3 location from which to import the package.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_create_package
opensearchservice_create_package <- function(PackageName, PackageType, PackageDescription = NULL, PackageSource) {
  op <- new_operation(
    name = "CreatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages",
    paginator = list()
  )
  input <- .opensearchservice$create_package_input(PackageName = PackageName, PackageType = PackageType, PackageDescription = PackageDescription, PackageSource = PackageSource)
  output <- .opensearchservice$create_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$create_package <- opensearchservice_create_package

#' Permanently deletes the specified domain and all of its data
#'
#' @description
#' Permanently deletes the specified domain and all of its data. Once a domain is deleted, it cannot be recovered.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/delete_domain.html](https://paws-r.github.io/docs/opensearchservice/delete_domain.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain you want to permanently delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_domain
opensearchservice_delete_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}",
    paginator = list()
  )
  input <- .opensearchservice$delete_domain_input(DomainName = DomainName)
  output <- .opensearchservice$delete_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_domain <- opensearchservice_delete_domain

#' Allows the remote domain owner to delete an existing inbound
#' cross-cluster connection
#'
#' @description
#' Allows the remote domain owner to delete an existing inbound cross-cluster connection.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/delete_inbound_connection.html](https://paws-r.github.io/docs/opensearchservice/delete_inbound_connection.html) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the inbound connection to permanently delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_inbound_connection
opensearchservice_delete_inbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "DeleteInboundConnection",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}",
    paginator = list()
  )
  input <- .opensearchservice$delete_inbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$delete_inbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_inbound_connection <- opensearchservice_delete_inbound_connection

#' Allows the local domain owner to delete an existing outbound
#' cross-cluster connection
#'
#' @description
#' Allows the local domain owner to delete an existing outbound cross-cluster connection.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/delete_outbound_connection.html](https://paws-r.github.io/docs/opensearchservice/delete_outbound_connection.html) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the outbound connection you want to permanently delete.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_outbound_connection
opensearchservice_delete_outbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "DeleteOutboundConnection",
    http_method = "DELETE",
    http_path = "/2021-01-01/opensearch/cc/outboundConnection/{ConnectionId}",
    paginator = list()
  )
  input <- .opensearchservice$delete_outbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$delete_outbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_outbound_connection <- opensearchservice_delete_outbound_connection

#' Deletes the package
#'
#' @description
#' Deletes the package.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/delete_package.html](https://paws-r.github.io/docs/opensearchservice/delete_package.html) for full documentation.
#'
#' @param PackageID &#91;required&#93; The internal ID of the package you want to delete. Use
#' [`describe_packages`][opensearchservice_describe_packages] to find this
#' value.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_delete_package
opensearchservice_delete_package <- function(PackageID) {
  op <- new_operation(
    name = "DeletePackage",
    http_method = "DELETE",
    http_path = "/2021-01-01/packages/{PackageID}",
    paginator = list()
  )
  input <- .opensearchservice$delete_package_input(PackageID = PackageID)
  output <- .opensearchservice$delete_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$delete_package <- opensearchservice_delete_package

#' Returns domain configuration information about the specified domain,
#' including the domain ID, domain endpoint, and domain ARN
#'
#' @description
#' Returns domain configuration information about the specified domain, including the domain ID, domain endpoint, and domain ARN.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_domain.html](https://paws-r.github.io/docs/opensearchservice/describe_domain.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain for which you want information.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain
opensearchservice_describe_domain <- function(DomainName) {
  op <- new_operation(
    name = "DescribeDomain",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_input(DomainName = DomainName)
  output <- .opensearchservice$describe_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain <- opensearchservice_describe_domain

#' Provides scheduled Auto-Tune action details for the domain, such as
#' Auto-Tune action type, description, severity, and scheduled date
#'
#' @description
#' Provides scheduled Auto-Tune action details for the domain, such as Auto-Tune action type, description, severity, and scheduled date.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_domain_auto_tunes.html](https://paws-r.github.io/docs/opensearchservice/describe_domain_auto_tunes.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain name for which you want Auto-Tune action details.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken. Used for pagination.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_auto_tunes
opensearchservice_describe_domain_auto_tunes <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDomainAutoTunes",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/autoTunes",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_auto_tunes_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_domain_auto_tunes_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_auto_tunes <- opensearchservice_describe_domain_auto_tunes

#' Returns information about the current blue/green deployment happening on
#' a domain, including a change ID, status, and progress stages
#'
#' @description
#' Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_domain_change_progress.html](https://paws-r.github.io/docs/opensearchservice/describe_domain_change_progress.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain you want to get the progress information about.
#' @param ChangeId The specific change ID for which you want to get progress information.
#' This is an optional parameter. If omitted, the service returns
#' information about the most recent configuration change.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_change_progress
opensearchservice_describe_domain_change_progress <- function(DomainName, ChangeId = NULL) {
  op <- new_operation(
    name = "DescribeDomainChangeProgress",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/progress",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_change_progress_input(DomainName = DomainName, ChangeId = ChangeId)
  output <- .opensearchservice$describe_domain_change_progress_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_change_progress <- opensearchservice_describe_domain_change_progress

#' Provides cluster configuration information about the specified domain,
#' such as the state, creation date, update version, and update date for
#' cluster options
#'
#' @description
#' Provides cluster configuration information about the specified domain, such as the state, creation date, update version, and update date for cluster options.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_domain_config.html](https://paws-r.github.io/docs/opensearchservice/describe_domain_config.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain you want to get information about.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domain_config
opensearchservice_describe_domain_config <- function(DomainName) {
  op <- new_operation(
    name = "DescribeDomainConfig",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/config",
    paginator = list()
  )
  input <- .opensearchservice$describe_domain_config_input(DomainName = DomainName)
  output <- .opensearchservice$describe_domain_config_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domain_config <- opensearchservice_describe_domain_config

#' Returns domain configuration information about the specified domains,
#' including the domain ID, domain endpoint, and domain ARN
#'
#' @description
#' Returns domain configuration information about the specified domains, including the domain ID, domain endpoint, and domain ARN.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_domains.html](https://paws-r.github.io/docs/opensearchservice/describe_domains.html) for full documentation.
#'
#' @param DomainNames &#91;required&#93; The domains for which you want information.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_domains
opensearchservice_describe_domains <- function(DomainNames) {
  op <- new_operation(
    name = "DescribeDomains",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain-info",
    paginator = list()
  )
  input <- .opensearchservice$describe_domains_input(DomainNames = DomainNames)
  output <- .opensearchservice$describe_domains_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_domains <- opensearchservice_describe_domains

#' Lists all the inbound cross-cluster connections for a remote domain
#'
#' @description
#' Lists all the inbound cross-cluster connections for a remote domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_inbound_connections.html](https://paws-r.github.io/docs/opensearchservice/describe_inbound_connections.html) for full documentation.
#'
#' @param Filters A list of filters used to match properties for inbound cross-cluster
#' connections. Available ` Filter ` values are:
#' 
#' -   connection-id
#' -   local-domain-info.domain-name
#' -   local-domain-info.owner-id
#' -   local-domain-info.region
#' -   remote-domain-info.domain-name
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken If more results are available and NextToken is present, make the next
#' request to the same API with the received NextToken to paginate the
#' remaining results.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_inbound_connections
opensearchservice_describe_inbound_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInboundConnections",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/search",
    paginator = list()
  )
  input <- .opensearchservice$describe_inbound_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_inbound_connections_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_inbound_connections <- opensearchservice_describe_inbound_connections

#' Describe the limits for a given instance type and OpenSearch or
#' Elasticsearch version
#'
#' @description
#' Describe the limits for a given instance type and OpenSearch or Elasticsearch version. When modifying an existing domain, specify the ` DomainName ` to see which limits you can modify.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_instance_type_limits.html](https://paws-r.github.io/docs/opensearchservice/describe_instance_type_limits.html) for full documentation.
#'
#' @param DomainName The name of the domain you want to modify. Only include this value if
#' you're querying OpenSearch ` Limits ` for an existing domain.
#' @param InstanceType &#91;required&#93; The instance type for an OpenSearch cluster for which OpenSearch
#' ` Limits ` are needed.
#' @param EngineVersion &#91;required&#93; Version of OpenSearch for which ` Limits ` are needed.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_instance_type_limits
opensearchservice_describe_instance_type_limits <- function(DomainName = NULL, InstanceType, EngineVersion) {
  op <- new_operation(
    name = "DescribeInstanceTypeLimits",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/instanceTypeLimits/{EngineVersion}/{InstanceType}",
    paginator = list()
  )
  input <- .opensearchservice$describe_instance_type_limits_input(DomainName = DomainName, InstanceType = InstanceType, EngineVersion = EngineVersion)
  output <- .opensearchservice$describe_instance_type_limits_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_instance_type_limits <- opensearchservice_describe_instance_type_limits

#' Lists all the outbound cross-cluster connections for a local domain
#'
#' @description
#' Lists all the outbound cross-cluster connections for a local domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_outbound_connections.html](https://paws-r.github.io/docs/opensearchservice/describe_outbound_connections.html) for full documentation.
#'
#' @param Filters A list of filters used to match properties for outbound cross-cluster
#' connections. Available ` Filter ` names for this operation are:
#' 
#' -   connection-id
#' -   remote-domain-info.domain-name
#' -   remote-domain-info.owner-id
#' -   remote-domain-info.region
#' -   local-domain-info.domain-name
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken parameter. Used for pagination.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_outbound_connections
opensearchservice_describe_outbound_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOutboundConnections",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/cc/outboundConnection/search",
    paginator = list()
  )
  input <- .opensearchservice$describe_outbound_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_outbound_connections_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_outbound_connections <- opensearchservice_describe_outbound_connections

#' Describes all packages available to Amazon OpenSearch Service domains
#'
#' @description
#' Describes all packages available to Amazon OpenSearch Service domains. Includes options for filtering, limiting the number of results, and pagination.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_packages.html](https://paws-r.github.io/docs/opensearchservice/describe_packages.html) for full documentation.
#'
#' @param Filters Only returns packages that match the `DescribePackagesFilterList`
#' values.
#' @param MaxResults Limits results to a maximum number of packages.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_packages
opensearchservice_describe_packages <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePackages",
    http_method = "POST",
    http_path = "/2021-01-01/packages/describe",
    paginator = list()
  )
  input <- .opensearchservice$describe_packages_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_packages_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_packages <- opensearchservice_describe_packages

#' Lists available reserved OpenSearch instance offerings
#'
#' @description
#' Lists available reserved OpenSearch instance offerings.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_reserved_instance_offerings.html](https://paws-r.github.io/docs/opensearchservice/describe_reserved_instance_offerings.html) for full documentation.
#'
#' @param ReservedInstanceOfferingId The offering identifier filter value. Use this parameter to show only
#' the available offering that matches the specified reservation
#' identifier.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken Provides an identifier to allow retrieval of paginated results.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_reserved_instance_offerings
opensearchservice_describe_reserved_instance_offerings <- function(ReservedInstanceOfferingId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstanceOfferings",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/reservedInstanceOfferings",
    paginator = list()
  )
  input <- .opensearchservice$describe_reserved_instance_offerings_input(ReservedInstanceOfferingId = ReservedInstanceOfferingId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_reserved_instance_offerings_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_reserved_instance_offerings <- opensearchservice_describe_reserved_instance_offerings

#' Returns information about reserved OpenSearch instances for this account
#'
#' @description
#' Returns information about reserved OpenSearch instances for this account.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/describe_reserved_instances.html](https://paws-r.github.io/docs/opensearchservice/describe_reserved_instances.html) for full documentation.
#'
#' @param ReservedInstanceId The reserved instance identifier filter value. Use this parameter to
#' show only the reservation that matches the specified reserved OpenSearch
#' instance ID.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken Provides an identifier to allow retrieval of paginated results.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_describe_reserved_instances
opensearchservice_describe_reserved_instances <- function(ReservedInstanceId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstances",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/reservedInstances",
    paginator = list()
  )
  input <- .opensearchservice$describe_reserved_instances_input(ReservedInstanceId = ReservedInstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$describe_reserved_instances_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$describe_reserved_instances <- opensearchservice_describe_reserved_instances

#' Dissociates a package from the Amazon OpenSearch Service domain
#'
#' @description
#' Dissociates a package from the Amazon OpenSearch Service domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/dissociate_package.html](https://paws-r.github.io/docs/opensearchservice/dissociate_package.html) for full documentation.
#'
#' @param PackageID &#91;required&#93; The internal ID of the package to associate with a domain. Use
#' [`describe_packages`][opensearchservice_describe_packages] to find this
#' value.
#' @param DomainName &#91;required&#93; The name of the domain to associate the package with.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_dissociate_package
opensearchservice_dissociate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "DissociatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages/dissociate/{PackageID}/{DomainName}",
    paginator = list()
  )
  input <- .opensearchservice$dissociate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .opensearchservice$dissociate_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$dissociate_package <- opensearchservice_dissociate_package

#' Returns a list of upgrade-compatible versions of
#' OpenSearch/Elasticsearch
#'
#' @description
#' Returns a list of upgrade-compatible versions of OpenSearch/Elasticsearch. You can optionally pass a ` DomainName ` to get all upgrade-compatible versions of OpenSearch/Elasticsearch for that specific domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/get_compatible_versions.html](https://paws-r.github.io/docs/opensearchservice/get_compatible_versions.html) for full documentation.
#'
#' @param DomainName 
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_compatible_versions
opensearchservice_get_compatible_versions <- function(DomainName = NULL) {
  op <- new_operation(
    name = "GetCompatibleVersions",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/compatibleVersions",
    paginator = list()
  )
  input <- .opensearchservice$get_compatible_versions_input(DomainName = DomainName)
  output <- .opensearchservice$get_compatible_versions_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_compatible_versions <- opensearchservice_get_compatible_versions

#' Returns a list of package versions, along with their creation time and
#' commit message
#'
#' @description
#' Returns a list of package versions, along with their creation time and commit message.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/get_package_version_history.html](https://paws-r.github.io/docs/opensearchservice/get_package_version_history.html) for full documentation.
#'
#' @param PackageID &#91;required&#93; Returns an audit history of package versions.
#' @param MaxResults Limits results to a maximum number of package versions.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_package_version_history
opensearchservice_get_package_version_history <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetPackageVersionHistory",
    http_method = "GET",
    http_path = "/2021-01-01/packages/{PackageID}/history",
    paginator = list()
  )
  input <- .opensearchservice$get_package_version_history_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$get_package_version_history_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_package_version_history <- opensearchservice_get_package_version_history

#' Retrieves the complete history of the last 10 upgrades performed on the
#' domain
#'
#' @description
#' Retrieves the complete history of the last 10 upgrades performed on the domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/get_upgrade_history.html](https://paws-r.github.io/docs/opensearchservice/get_upgrade_history.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_upgrade_history
opensearchservice_get_upgrade_history <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetUpgradeHistory",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/upgradeDomain/{DomainName}/history",
    paginator = list()
  )
  input <- .opensearchservice$get_upgrade_history_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$get_upgrade_history_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_upgrade_history <- opensearchservice_get_upgrade_history

#' Retrieves the latest status of the last upgrade or upgrade eligibility
#' check performed on the domain
#'
#' @description
#' Retrieves the latest status of the last upgrade or upgrade eligibility check performed on the domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/get_upgrade_status.html](https://paws-r.github.io/docs/opensearchservice/get_upgrade_status.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname opensearchservice_get_upgrade_status
opensearchservice_get_upgrade_status <- function(DomainName) {
  op <- new_operation(
    name = "GetUpgradeStatus",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/upgradeDomain/{DomainName}/status",
    paginator = list()
  )
  input <- .opensearchservice$get_upgrade_status_input(DomainName = DomainName)
  output <- .opensearchservice$get_upgrade_status_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$get_upgrade_status <- opensearchservice_get_upgrade_status

#' Returns the names of all domains owned by the current user's account
#'
#' @description
#' Returns the names of all domains owned by the current user's account.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/list_domain_names.html](https://paws-r.github.io/docs/opensearchservice/list_domain_names.html) for full documentation.
#'
#' @param EngineType Optional parameter to filter the output by domain engine type.
#' Acceptable values are 'Elasticsearch' and 'OpenSearch'.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_domain_names
opensearchservice_list_domain_names <- function(EngineType = NULL) {
  op <- new_operation(
    name = "ListDomainNames",
    http_method = "GET",
    http_path = "/2021-01-01/domain",
    paginator = list()
  )
  input <- .opensearchservice$list_domain_names_input(EngineType = EngineType)
  output <- .opensearchservice$list_domain_names_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_domain_names <- opensearchservice_list_domain_names

#' Lists all Amazon OpenSearch Service domains associated with the package
#'
#' @description
#' Lists all Amazon OpenSearch Service domains associated with the package.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/list_domains_for_package.html](https://paws-r.github.io/docs/opensearchservice/list_domains_for_package.html) for full documentation.
#'
#' @param PackageID &#91;required&#93; The package for which to list associated domains.
#' @param MaxResults Limits the results to a maximum number of domains.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_domains_for_package
opensearchservice_list_domains_for_package <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomainsForPackage",
    http_method = "GET",
    http_path = "/2021-01-01/packages/{PackageID}/domains",
    paginator = list()
  )
  input <- .opensearchservice$list_domains_for_package_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_domains_for_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_domains_for_package <- opensearchservice_list_domains_for_package

#' List instance type details
#'
#' @description
#' List instance type details
#'
#' See [https://paws-r.github.io/docs/opensearchservice/list_instance_type_details.html](https://paws-r.github.io/docs/opensearchservice/list_instance_type_details.html) for full documentation.
#'
#' @param EngineVersion &#91;required&#93; 
#' @param DomainName 
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_instance_type_details
opensearchservice_list_instance_type_details <- function(EngineVersion, DomainName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListInstanceTypeDetails",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/instanceTypeDetails/{EngineVersion}",
    paginator = list()
  )
  input <- .opensearchservice$list_instance_type_details_input(EngineVersion = EngineVersion, DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_instance_type_details_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_instance_type_details <- opensearchservice_list_instance_type_details

#' Lists all packages associated with the Amazon OpenSearch Service domain
#'
#' @description
#' Lists all packages associated with the Amazon OpenSearch Service domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/list_packages_for_domain.html](https://paws-r.github.io/docs/opensearchservice/list_packages_for_domain.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain for which you want to list associated packages.
#' @param MaxResults Limits results to a maximum number of packages.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_packages_for_domain
opensearchservice_list_packages_for_domain <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPackagesForDomain",
    http_method = "GET",
    http_path = "/2021-01-01/domain/{DomainName}/packages",
    paginator = list()
  )
  input <- .opensearchservice$list_packages_for_domain_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_packages_for_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_packages_for_domain <- opensearchservice_list_packages_for_domain

#' Returns all tags for the given domain
#'
#' @description
#' Returns all tags for the given domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/list_tags.html](https://paws-r.github.io/docs/opensearchservice/list_tags.html) for full documentation.
#'
#' @param ARN &#91;required&#93; Specify the `ARN` of the domain that the tags you want to view are
#' attached to.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_tags
opensearchservice_list_tags <- function(ARN) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/2021-01-01/tags/",
    paginator = list()
  )
  input <- .opensearchservice$list_tags_input(ARN = ARN)
  output <- .opensearchservice$list_tags_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_tags <- opensearchservice_list_tags

#' List all supported versions of OpenSearch and Elasticsearch
#'
#' @description
#' List all supported versions of OpenSearch and Elasticsearch.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/list_versions.html](https://paws-r.github.io/docs/opensearchservice/list_versions.html) for full documentation.
#'
#' @param MaxResults Set this value to limit the number of results returned. Value must be
#' greater than 10 or it won't be honored.
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname opensearchservice_list_versions
opensearchservice_list_versions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListVersions",
    http_method = "GET",
    http_path = "/2021-01-01/opensearch/versions",
    paginator = list()
  )
  input <- .opensearchservice$list_versions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .opensearchservice$list_versions_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$list_versions <- opensearchservice_list_versions

#' Allows you to purchase reserved OpenSearch instances
#'
#' @description
#' Allows you to purchase reserved OpenSearch instances.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/purchase_reserved_instance_offering.html](https://paws-r.github.io/docs/opensearchservice/purchase_reserved_instance_offering.html) for full documentation.
#'
#' @param ReservedInstanceOfferingId &#91;required&#93; The ID of the reserved OpenSearch instance offering to purchase.
#' @param ReservationName &#91;required&#93; A customer-specified identifier to track this reservation.
#' @param InstanceCount The number of OpenSearch instances to reserve.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_purchase_reserved_instance_offering
opensearchservice_purchase_reserved_instance_offering <- function(ReservedInstanceOfferingId, ReservationName, InstanceCount = NULL) {
  op <- new_operation(
    name = "PurchaseReservedInstanceOffering",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/purchaseReservedInstanceOffering",
    paginator = list()
  )
  input <- .opensearchservice$purchase_reserved_instance_offering_input(ReservedInstanceOfferingId = ReservedInstanceOfferingId, ReservationName = ReservationName, InstanceCount = InstanceCount)
  output <- .opensearchservice$purchase_reserved_instance_offering_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$purchase_reserved_instance_offering <- opensearchservice_purchase_reserved_instance_offering

#' Allows the remote domain owner to reject an inbound cross-cluster
#' connection request
#'
#' @description
#' Allows the remote domain owner to reject an inbound cross-cluster connection request.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/reject_inbound_connection.html](https://paws-r.github.io/docs/opensearchservice/reject_inbound_connection.html) for full documentation.
#'
#' @param ConnectionId &#91;required&#93; The ID of the inbound connection to reject.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_reject_inbound_connection
opensearchservice_reject_inbound_connection <- function(ConnectionId) {
  op <- new_operation(
    name = "RejectInboundConnection",
    http_method = "PUT",
    http_path = "/2021-01-01/opensearch/cc/inboundConnection/{ConnectionId}/reject",
    paginator = list()
  )
  input <- .opensearchservice$reject_inbound_connection_input(ConnectionId = ConnectionId)
  output <- .opensearchservice$reject_inbound_connection_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$reject_inbound_connection <- opensearchservice_reject_inbound_connection

#' Removes the specified set of tags from the given domain
#'
#' @description
#' Removes the specified set of tags from the given domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/remove_tags.html](https://paws-r.github.io/docs/opensearchservice/remove_tags.html) for full documentation.
#'
#' @param ARN &#91;required&#93; The `ARN` of the domain from which you want to delete the specified
#' tags.
#' @param TagKeys &#91;required&#93; The `TagKey` list you want to remove from the domain.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_remove_tags
opensearchservice_remove_tags <- function(ARN, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/2021-01-01/tags-removal",
    paginator = list()
  )
  input <- .opensearchservice$remove_tags_input(ARN = ARN, TagKeys = TagKeys)
  output <- .opensearchservice$remove_tags_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$remove_tags <- opensearchservice_remove_tags

#' Schedules a service software update for an Amazon OpenSearch Service
#' domain
#'
#' @description
#' Schedules a service software update for an Amazon OpenSearch Service domain.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/start_service_software_update.html](https://paws-r.github.io/docs/opensearchservice/start_service_software_update.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update to the latest service
#' software.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_start_service_software_update
opensearchservice_start_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "StartServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/serviceSoftwareUpdate/start",
    paginator = list()
  )
  input <- .opensearchservice$start_service_software_update_input(DomainName = DomainName)
  output <- .opensearchservice$start_service_software_update_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$start_service_software_update <- opensearchservice_start_service_software_update

#' Modifies the cluster configuration of the specified domain, such as
#' setting the instance type and the number of instances
#'
#' @description
#' Modifies the cluster configuration of the specified domain, such as setting the instance type and the number of instances.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/update_domain_config.html](https://paws-r.github.io/docs/opensearchservice/update_domain_config.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain you're updating.
#' @param ClusterConfig The type and number of instances to instantiate for the domain cluster.
#' @param EBSOptions Specify the type and size of the EBS volume to use.
#' @param SnapshotOptions Option to set the time, in UTC format, for the daily automated snapshot.
#' Default value is `0` hours.
#' @param VPCOptions Options to specify the subnets and security groups for the VPC endpoint.
#' For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html"
#' target="_blank">Launching your Amazon OpenSearch Service domains using a
#' VPC</a> .
#' @param CognitoOptions Options to specify the Cognito user and identity pools for OpenSearch
#' Dashboards authentication. For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
#' target="_blank">Configuring Amazon Cognito authentication for OpenSearch
#' Dashboards</a>.
#' @param AdvancedOptions Modifies the advanced option to allow references to indices in an HTTP
#' request body. Must be `false` when configuring access to individual
#' sub-resources. By default, the value is `true`. See <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options"
#' target="_blank">Advanced options</a> for more information.
#' @param AccessPolicies IAM access policy as a JSON-formatted string.
#' @param LogPublishingOptions Map of `LogType` and `LogPublishingOption`, each containing options to
#' publish a given type of OpenSearch log.
#' @param EncryptionAtRestOptions Specifies encryption of data at rest options.
#' @param DomainEndpointOptions Options to specify configuration that will be applied to the domain
#' endpoint.
#' @param NodeToNodeEncryptionOptions Specifies node-to-node encryption options.
#' @param AdvancedSecurityOptions Specifies advanced security options.
#' @param AutoTuneOptions Specifies Auto-Tune options.
#' @param DryRun This flag, when set to True, specifies whether the `UpdateDomain`
#' request should return the results of validation checks (DryRunResults)
#' without actually applying the change.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_domain_config
opensearchservice_update_domain_config <- function(DomainName, ClusterConfig = NULL, EBSOptions = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, AdvancedOptions = NULL, AccessPolicies = NULL, LogPublishingOptions = NULL, EncryptionAtRestOptions = NULL, DomainEndpointOptions = NULL, NodeToNodeEncryptionOptions = NULL, AdvancedSecurityOptions = NULL, AutoTuneOptions = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "UpdateDomainConfig",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/domain/{DomainName}/config",
    paginator = list()
  )
  input <- .opensearchservice$update_domain_config_input(DomainName = DomainName, ClusterConfig = ClusterConfig, EBSOptions = EBSOptions, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, AdvancedOptions = AdvancedOptions, AccessPolicies = AccessPolicies, LogPublishingOptions = LogPublishingOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, DomainEndpointOptions = DomainEndpointOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, AdvancedSecurityOptions = AdvancedSecurityOptions, AutoTuneOptions = AutoTuneOptions, DryRun = DryRun)
  output <- .opensearchservice$update_domain_config_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_domain_config <- opensearchservice_update_domain_config

#' Updates a package for use with Amazon OpenSearch Service domains
#'
#' @description
#' Updates a package for use with Amazon OpenSearch Service domains.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/update_package.html](https://paws-r.github.io/docs/opensearchservice/update_package.html) for full documentation.
#'
#' @param PackageID &#91;required&#93; The unique identifier for the package.
#' @param PackageSource &#91;required&#93; 
#' @param PackageDescription A new description of the package.
#' @param CommitMessage A commit message for the new version which is shown as part of
#' `GetPackageVersionHistoryResponse`.
#'
#' @keywords internal
#'
#' @rdname opensearchservice_update_package
opensearchservice_update_package <- function(PackageID, PackageSource, PackageDescription = NULL, CommitMessage = NULL) {
  op <- new_operation(
    name = "UpdatePackage",
    http_method = "POST",
    http_path = "/2021-01-01/packages/update",
    paginator = list()
  )
  input <- .opensearchservice$update_package_input(PackageID = PackageID, PackageSource = PackageSource, PackageDescription = PackageDescription, CommitMessage = CommitMessage)
  output <- .opensearchservice$update_package_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$update_package <- opensearchservice_update_package

#' Allows you to either upgrade your domain or perform an upgrade
#' eligibility check to a compatible version of OpenSearch or Elasticsearch
#'
#' @description
#' Allows you to either upgrade your domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.
#'
#' See [https://paws-r.github.io/docs/opensearchservice/upgrade_domain.html](https://paws-r.github.io/docs/opensearchservice/upgrade_domain.html) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#' @param TargetVersion &#91;required&#93; The version of OpenSearch you intend to upgrade the domain to.
#' @param PerformCheckOnly When true, indicates that an upgrade eligibility check needs to be
#' performed. Does not actually perform the upgrade.
#' @param AdvancedOptions 
#'
#' @keywords internal
#'
#' @rdname opensearchservice_upgrade_domain
opensearchservice_upgrade_domain <- function(DomainName, TargetVersion, PerformCheckOnly = NULL, AdvancedOptions = NULL) {
  op <- new_operation(
    name = "UpgradeDomain",
    http_method = "POST",
    http_path = "/2021-01-01/opensearch/upgradeDomain",
    paginator = list()
  )
  input <- .opensearchservice$upgrade_domain_input(DomainName = DomainName, TargetVersion = TargetVersion, PerformCheckOnly = PerformCheckOnly, AdvancedOptions = AdvancedOptions)
  output <- .opensearchservice$upgrade_domain_output()
  config <- get_config()
  svc <- .opensearchservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.opensearchservice$operations$upgrade_domain <- opensearchservice_upgrade_domain
