% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_list_assignments_for_hit}
\alias{mturk_list_assignments_for_hit}
\title{The ListAssignmentsForHIT operation retrieves completed assignments for
a HIT}
\usage{
mturk_list_assignments_for_hit(HITId, NextToken, MaxResults,
  AssignmentStatuses)
}
\arguments{
\item{HITId}{[required] The ID of the HIT.}

\item{NextToken}{Pagination token}

\item{MaxResults}{}

\item{AssignmentStatuses}{The status of the assignments to return: Submitted \\| Approved \\|
Rejected}
}
\description{
The \code{ListAssignmentsForHIT} operation retrieves completed assignments
for a HIT. You can use this operation to retrieve the results for a HIT.
}
\details{
You can get assignments for a HIT at any time, even if the HIT is not
yet Reviewable. If a HIT requested multiple assignments, and has
received some results but has not yet become Reviewable, you can still
retrieve the partial results with this operation.

Use the AssignmentStatus parameter to control which set of assignments
for a HIT are returned. The ListAssignmentsForHIT operation can return
submitted assignments awaiting approval, or it can return assignments
that have already been approved or rejected. You can set
AssignmentStatus=Approved,Rejected to get assignments that have already
been approved and rejected together in one result set.

Only the Requester who created the HIT can retrieve the assignments for
that HIT.

Results are sorted and divided into numbered pages and the operation
returns a single page of results. You can use the parameters of the
operation to control sorting and pagination.
}
\section{Request syntax}{
\preformatted{svc$list_assignments_for_hit(
  HITId = "string",
  NextToken = "string",
  MaxResults = 123,
  AssignmentStatuses = list(
    "Submitted"|"Approved"|"Rejected"
  )
)
}
}

\keyword{internal}
