# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon CloudSearch Domain
#'
#' @description
#' You use the AmazonCloudSearch2013 API to upload documents to a search
#' domain and search those documents.
#' 
#' The endpoints for submitting `UploadDocuments`, `Search`, and `Suggest`
#' requests are domain-specific. To get the endpoints for your domain, use
#' the Amazon CloudSearch configuration service `DescribeDomains` action.
#' The domain endpoints are also displayed on the domain dashboard in the
#' Amazon CloudSearch console. You submit suggest requests to the search
#' endpoint.
#' 
#' For more information, see the [Amazon CloudSearch Developer
#' Guide](http://docs.aws.amazon.com/cloudsearch/latest/developerguide).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- cloudsearchdomain(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloudsearchdomain()
#' svc$search(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloudsearchdomain_search]{search} \tab Retrieves a list of documents that match the specified search criteria\cr
#'  \link[=cloudsearchdomain_suggest]{suggest} \tab Retrieves autocomplete suggestions for a partial query string \cr
#'  \link[=cloudsearchdomain_upload_documents]{upload_documents} \tab Posts a batch of documents to a search domain for indexing 
#' }
#'
#' @rdname cloudsearchdomain
#' @export
cloudsearchdomain <- function(config = list()) {
  svc <- .cloudsearchdomain$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloudsearchdomain <- list()

.cloudsearchdomain$operations <- list()

.cloudsearchdomain$metadata <- list(
  service_name = "cloudsearchdomain",
  endpoints = list("*" = list(endpoint = "cloudsearchdomain.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloudsearchdomain.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "CloudSearch Domain",
  api_version = "2013-01-01",
  signing_name = "cloudsearch",
  json_version = "1.1",
  target_prefix = ""
)

.cloudsearchdomain$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.cloudsearchdomain$metadata, handlers, config)
}
