% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tetraplot.R
\name{tetraplot}
\alias{tetraplot}
\title{Plot a static tetrahedral colorspace}
\usage{
tetraplot(tcsdata, vertexsize = 0.8, achro = TRUE, achrosize = 0.8,
  achrocol = "grey", out.lwd = 1, out.lcol = "darkgrey", view = 70,
  scale.y = 1, axis = FALSE, grid = FALSE, xlim = c(-1.22, 0.612),
  ylim = c(-0.35, 0.707), zlim = c(-0.25, 0.75), margin = c(1, 1, 1, 1),
  ...)
}
\arguments{
\item{tcsdata}{(required) a data frame, possibly a result from the \code{colspace} 
or \code{tetraspace} function, containing values for the 'x', 'y' and 'z' 
coordinates as columns (labeled as such).}

\item{vertexsize}{size of the points at the vertices (defaults to 0.8).}

\item{achrosize}{size of the point in the achromatic center (defaults to 0.8).}

\item{achrocol}{color of the point in the achromatic center (defaults to 'grey').}

\item{out.lwd, out.lcol}{graphical parameters for the tetrahedral outline.}

\item{view}{orientation of the tetrahedron in degrees (defaults to 70).}

\item{scale.y}{numeric. Perspective scaling of the y axis (defaults to 0.45).}

\item{axis}{logical. Draw X, Y and Z axis (defaults to FALSE).}

\item{grid}{logical. Draw grid (defaults to FALSE).}

\item{xlim, ylim, zlim}{axis limits.}

\item{margin}{vector of four numbers specifying drawing margins (defaults to c(1, 1, 1, 1)).}
}
\value{
\code{tetraplot} creates a 3D plot using functions of the package \code{scatterplot3d}.
}
\description{
Produces a static 3D tetrahedral plot.
}
\examples{
\dontrun{

# For plotting
data(sicalis)
vis.sicalis <- vismodel(sicalis, visual = 'avg.uv')
tcs.sicalis <- colspace(vis.sicalis, space = 'tcs')
plot(tcs.sicalis)

}

}
\references{
Stoddard, M. C., & Prum, R. O. (2008). Evolution of avian plumage 
 color in a tetrahedral color space: A phylogenetic analysis of new world buntings. 
 The American Naturalist, 171(6), 755-776.

Endler, J. A., & Mielke, P. (2005). Comparing entire colour patterns 
 as birds see them. Biological Journal Of The Linnean Society, 86(4), 405-431.
}
\seealso{
\code{\link[rgl]{spheres3d}},\code{\link[rgl]{rgl.postscript}}, 
\code{\link[rgl]{rgl.snapshot}},\code{\link[rgl]{rgl.material}}
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}

Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
