% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_combineVerticallyGGplot.R
\name{combineVerticallyGGplot}
\alias{combineVerticallyGGplot}
\title{Combine vertically multiple \code{\link[ggplot2]{ggplot}}.}
\usage{
combineVerticallyGGplot(
  listPlots,
  maxNLines = NULL,
  nCores = 1,
  shiny = FALSE,
  verbose = FALSE,
  reportPerSubject = FALSE
)
}
\arguments{
\item{listPlots}{listPlots per subject as created inside the
\code{\link{subjectProfileCombine}} function.}

\item{maxNLines}{Maximum number of lines for a combined plot,
to fit in the page height. \cr
When the different visualizations
are combined for each subject, they will be allocated 
to different pages if the number of lines of the combined visualization
is higher than this number.}

\item{nCores}{Integer containing the number of cores used for the computation
(1 by default). If more than 1, computation is parallelized, in this case
the package \code{parallel} is required.}

\item{shiny}{logical, set to TRUE (FALSE by default) 
if the report is generated from a Shiny application.
Messages during report creation will be included in the Shiny interface,
and it will be mentioned at the end of the report.
In this case, the \code{shiny} package should be available.}

\item{verbose}{logical, if TRUE print messages during execution}

\item{reportPerSubject}{Logical, if TRUE (FALSE by default)
export a subject profile report by subject.}
}
\value{
a list (by subject) of list (by page)
of \code{\link[ggplot2]{ggplot}} object
}
\description{
If the different modules for a subject don't fit in the page, there
are automatically split in multiple pages.
The margins are extracted across plots to ensure that plots will
be probably aligned.
}
\author{
Laure Cougnaud
}
