% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{fill_traj_gaps}
\alias{fill_traj_gaps}
\title{Interpolate gaps within trajectories}
\usage{
fill_traj_gaps(
  obj_name,
  loess_degree = 1,
  loess_criterion = c("aicc", "gcv"),
  loess_family = c("gaussian", "symmetric"),
  loess_user_span = NULL
)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}. Trajectories must be
predefined (i.e. via \code{separate_trajectories()}).}

\item{loess_degree}{See "degree" argument of fANCOVA::loess.as()}

\item{loess_criterion}{See "criterion" argument of fANCOVA::loess.as()}

\item{loess_family}{See "family" argument of fANCOVA::loess.as()}

\item{loess_user_span}{See "user.span" argument of fANCOVA::loess.as()}
}
\value{
A viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"} that now includes new
observations (rows) as a result of interpolation to fill in missing data. A
new column \code{gaps_filled} is added to the data to indicate original
data ("No") vs data that have been inserted to fill gaps ("Yes").
}
\description{
Use LOESS smoothing to fill in gaps of missing data within trajectories in
a viewr object
}
\details{
It is strongly recommended that the input viewr object be "cleaned"
via \code{select_x_percent()} -> \code{separate_trajectories()} ->
\code{get_full_trajectories()} prior to using this function. Doing so will
ensure that only trajectories with minor gaps will be used in your
analyses. This function will then enable you to interpolate missing data in
those minor gaps.

Interpolation is handled by first fitting a series of LOESS regressions
(via \code{fANCOVA::loess.as()}). In each regression, a position axis (e.g.
\code{position_length}) is regressed against \code{frame} (\code{frame} is
x-axis). From that relationship, values of missing position data are
determined and then inserted into the original data set.

See \link[fANCOVA]{loess.as} for further details on parameters.
}
\examples{
library(pathviewr)

## Import the example Motive data included in the package
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                             package = 'pathviewr'))

## Clean, isolate, and label trajectories
motive_full <-
  motive_data \%>\%
  clean_viewr(desired_percent = 50,
              max_frame_gap = "autodetect",
              span = 0.95)

## Interpolate missing data via this function
motive_filling <-
 motive_full \%>\%
 fill_traj_gaps()

## plot all trajectories (before)
plot_viewr_trajectories(motive_full, multi_plot = TRUE)
## plot all trajectories(after)
plot_viewr_trajectories(motive_filling, multi_plot = TRUE)
}
\author{
Vikram B. Baliga
}
