% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{find_curve_elbow}
\alias{find_curve_elbow}
\title{Find the "elbow" of a curve.}
\usage{
find_curve_elbow(data_frame, export_type = "row_num", plot_curve = FALSE)
}
\arguments{
\item{data_frame}{A two-column data frame (numeric entries only)}

\item{export_type}{If "row_num" (the default), the row number of the elbow
point is returned. If anything else, the entire row of the original data
frame is returned.}

\item{plot_curve}{Default FALSE; should the curve be plotted?}
}
\value{
If \code{export_type} is \code{row_num} the row number of the elbow
point is returned. If anything else is used for that argument, the entire
row of the original data frame on which the "elbow" is located is returned.
If \code{plot_curve} is \code{TRUE}, the curve is plotted along with a
vertical line drawn at the computed elbow point.
}
\description{
For bivariate data that show monotonic decreases (e.g. plots of trajectory
count vs. frame gap allowed, or scree plots from PCAs), this function will
find the "elbow" point. This is done by drawing an (imaginary) line between
the first observation and the final observation. Then, the distance between
that line and each observation is calculated. The "elbow" of the curve is the
observation that maximizes this distance.
}
\examples{
df <- data.frame(x = seq(1:10),
                 y = 1/seq(1:10))
plot(df)
find_curve_elbow(df, plot_curve = TRUE)
}
\seealso{
Other mathematical functions: 
\code{\link{calc_min_dist_v}()},
\code{\link{deg_2_rad}()},
\code{\link{get_2d_angle}()},
\code{\link{get_3d_angle}()},
\code{\link{get_3d_cross_prod}()},
\code{\link{get_dist_point_line}()},
\code{\link{get_velocity}()},
\code{\link{rad_2_deg}()}
}
\author{
Vikram B. Baliga
}
\concept{mathematical functions}
