% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_etopo.R
\name{load_etopo}
\alias{load_etopo}
\title{Load the ETOPO global relief}
\usage{
load_etopo(path = NULL, resolution = 60, version = "1")
}
\arguments{
\item{path}{character. Path where the dataset is stored. If left NULL, the data
will be downloaded from the directory returned by \code{\link[=get_data_path]{get_data_path()}}}

\item{resolution}{numeric resolution in arcsecs (one of 30, or 60).
Defaults to 60 arcsecs.}

\item{version}{character or numeric. The ETOPO2022 version number.
Only "1" supported at the moment}
}
\value{
a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of relief
}
\description{
This function loads previously downloaded ETOPO 2022 global relief dataset, at
30 or 60 arcsec resolution. To save the variables in a compatible
format, use \code{\link[=download_etopo]{download_etopo()}}.
}
\details{
The function assumes that the file name is \verb{etopo2022_\{resolution\}s_v1.nc}
}
\keyword{internal}
