% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_class.R, R/predict_classprob.R,
%   R/predict_hazard.R, R/predict_interval.R, R/predict_linear_pred.R,
%   R/predict_numeric.R, R/predict_quantile.R, R/predict_survival.R,
%   R/predict_time.R
\name{predict_class.model_fit}
\alias{predict_class.model_fit}
\alias{predict_classprob.model_fit}
\alias{predict_hazard.model_fit}
\alias{predict_confint.model_fit}
\alias{predict_confint}
\alias{predict_predint}
\alias{predict_predint.model_fit}
\alias{predict_linear_pred.model_fit}
\alias{predict_linear_pred}
\alias{predict_numeric.model_fit}
\alias{predict_numeric}
\alias{predict_quantile.model_fit}
\alias{predict_survival.model_fit}
\alias{predict_survival}
\alias{predict_time.model_fit}
\alias{predict_time}
\title{Other predict methods.}
\usage{
\method{predict_class}{model_fit}(object, new_data, ...)

\method{predict_classprob}{model_fit}(object, new_data, ...)

\method{predict_hazard}{model_fit}(object, new_data, eval_time, time = deprecated(), ...)

\method{predict_confint}{model_fit}(object, new_data, level = 0.95, std_error = FALSE, ...)

predict_confint(object, ...)

predict_predint(object, ...)

\method{predict_predint}{model_fit}(object, new_data, level = 0.95, std_error = FALSE, ...)

predict_predint(object, ...)

\method{predict_linear_pred}{model_fit}(object, new_data, ...)

predict_linear_pred(object, ...)

\method{predict_numeric}{model_fit}(object, new_data, ...)

predict_numeric(object, ...)

\method{predict_quantile}{model_fit}(
  object,
  new_data,
  quantile_levels = NULL,
  quantile = deprecated(),
  interval = "none",
  level = 0.95,
  ...
)

\method{predict_survival}{model_fit}(
  object,
  new_data,
  eval_time,
  time = deprecated(),
  interval = "none",
  level = 0.95,
  ...
)

predict_survival(object, ...)

\method{predict_time}{model_fit}(object, new_data, ...)

predict_time(object, ...)
}
\arguments{
\item{object}{A \link[=model_fit]{model fit}.}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{...}{Additional \code{parsnip}-related options, depending on the
value of \code{type}. Arguments to the underlying model's prediction
function cannot be passed here (use the \code{opts} argument instead).
Possible arguments are:
\itemize{
\item \code{interval}: for \code{type} equal to \code{"survival"} or \code{"quantile"}, should
interval estimates be added, if available? Options are \code{"none"}
and \code{"confidence"}.
\item \code{level}: for \code{type} equal to \code{"conf_int"}, \code{"pred_int"}, or \code{"survival"},
this is the parameter for the tail area of the intervals
(e.g. confidence level for confidence intervals).
Default value is \code{0.95}.
\item \code{std_error}: for \code{type} equal to \code{"conf_int"} or \code{"pred_int"}, add
the standard error of fit or prediction (on the scale of the
linear predictors). Default value is \code{FALSE}.
\item \code{quantile}: for \code{type} equal to \code{quantile}, the quantiles of the
distribution. Default is \code{(1:9)/10}.
\item \code{eval_time}: for \code{type} equal to \code{"survival"} or \code{"hazard"}, the
time points at which the survival probability or hazard is estimated.
}}

\item{level}{A single numeric value between zero and one for the
interval estimates.}

\item{std_error}{A single logical for whether the standard error should be
returned (assuming that the model can compute it).}

\item{quantile, quantile_levels}{A vector of values between 0 and 1 for the
quantile to be predicted. If the model has a \code{"quantile regression"} mode,
this value should be \code{NULL}. For other modes, the default is \code{(1:9)/10}.
Note that, as of version 1.3.0 of parsnip, the \code{quantile} is deprecated. Use
\code{quantile_levels} instead.}
}
\description{
These are internal functions not meant to be directly called by the user.
}
\keyword{internal}
