% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_tree_spark.R
\name{details_decision_tree_spark}
\alias{details_decision_tree_spark}
\title{Decision trees via Spark}
\description{
\code{\link[sparklyr:ml_decision_tree]{sparklyr::ml_decision_tree()}} fits a model as a set of \verb{if/then}
statements that creates a tree-based structure.
}
\details{
For this engine, there are multiple modes: classification and regression
\subsection{Tuning Parameters}{

This model has 2 tuning parameters:
\itemize{
\item \code{tree_depth}: Tree Depth (type: integer, default: 5L)
\item \code{min_n}: Minimal Node Size (type: integer, default: 1L)
}
}

\subsection{Translation from parsnip to the original package (classification)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{decision_tree(tree_depth = integer(1), min_n = integer(1)) \%>\% 
  set_engine("spark") \%>\% 
  set_mode("classification") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Decision Tree Model Specification (classification)
## 
## Main Arguments:
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_decision_tree_classifier(x = missing_arg(), formula = missing_arg(), 
##     max_depth = integer(1), min_instances_per_node = min_rows(0L, 
##         x), seed = sample.int(10^5, 1))
}\if{html}{\out{</div>}}
}

\subsection{Translation from parsnip to the original package (regression)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{decision_tree(tree_depth = integer(1), min_n = integer(1)) \%>\% 
  set_engine("spark") \%>\% 
  set_mode("regression") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Decision Tree Model Specification (regression)
## 
## Main Arguments:
##   tree_depth = integer(1)
##   min_n = integer(1)
## 
## Computational engine: spark 
## 
## Model fit template:
## sparklyr::ml_decision_tree_regressor(x = missing_arg(), formula = missing_arg(), 
##     max_depth = integer(1), min_instances_per_node = min_rows(0L, 
##         x), seed = sample.int(10^5, 1))
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

This engine does not require any special encoding of the predictors.
Categorical predictors can be partitioned into groups of factor levels
(e.g. \verb{\{a, c\}} vs \verb{\{b, d\}}) when splitting at a node. Dummy variables
are not required for this model.
}

\subsection{Case weights}{

This model can utilize case weights during model fitting. To use them,
see the documentation in \link{case_weights} and the examples
on \code{tidymodels.org}.

The \code{fit()} and \code{fit_xy()} arguments have arguments called
\code{case_weights} that expect vectors of case weights.

Note that, for spark engines, the \code{case_weight} argument value should be
a character string to specify the column with the numeric case weights.
}

\subsection{Other details}{

For models created using the \code{"spark"} engine, there are several things
to consider.
\itemize{
\item Only the formula interface to via \code{fit()} is available; using
\code{fit_xy()} will generate an error.
\item The predictions will always be in a Spark table format. The names will
be the same as documented but without the dots.
\item There is no equivalent to factor columns in Spark tables so class
predictions are returned as character columns.
\item To retain the model object for a new R session (via \code{save()}), the
\code{model$fit} element of the parsnip object should be serialized via
\code{ml_save(object$fit)} and separately saved to disk. In a new session,
the object can be reloaded and reattached to the parsnip object.
}
}

\subsection{References}{
\itemize{
\item Kuhn, M, and K Johnson. 2013. \emph{Applied Predictive Modeling}. Springer.
}
}
}
\keyword{internal}
