% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_keras.R
\name{details_logistic_reg_keras}
\alias{details_logistic_reg_keras}
\title{Logistic regression via keras}
\description{
\code{\link[=keras_mlp]{keras_mlp()}} fits a generalized linear model for binary outcomes. A
linear combination of the predictors is used to model the log odds of an
event.
}
\details{
For this engine, there is a single mode: classification
\subsection{Tuning Parameters}{

This model has one tuning parameter:
\itemize{
\item \code{penalty}: Amount of Regularization (type: double, default: 0.0)
}

For \code{penalty}, the amount of regularization is \emph{only} L2 penalty (i.e.,
ridge or weight decay).
}

\subsection{Translation from parsnip to the original package}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{logistic_reg(penalty = double(1)) \%>\% 
  set_engine("keras") \%>\% 
  translate()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Logistic Regression Model Specification (classification)
## 
## Main Arguments:
##   penalty = double(1)
## 
## Computational engine: keras 
## 
## Model fit template:
## parsnip::keras_mlp(x = missing_arg(), y = missing_arg(), penalty = double(1), 
##     hidden_units = 1, act = "linear")
}\if{html}{\out{</div>}}

\code{\link[=keras_mlp]{keras_mlp()}} is a parsnip wrapper around keras code for
neural networks. This model fits a linear regression as a network with a
single hidden unit.
}

\subsection{Preprocessing requirements}{

Factor/categorical predictors need to be converted to numeric values
(e.g., dummy or indicator variables) for this engine. When using the
formula method via \code{\link[=fit.model_spec]{fit()}}, parsnip will
convert factor columns to indicators.

Predictors should have the same scale. One way to achieve this is to
center and scale each so that each predictor has mean zero and a
variance of one.
}

\subsection{Case weights}{

The underlying model implementation does not allow for case weights.
}

\subsection{Saving fitted model objects}{

Models fitted with this engine may require native serialization methods
to be properly saved and/or passed between R sessions. To learn more
about preparing fitted models for serialization, see the bundle package.
}

\subsection{Examples}{

The “Fitting and Predicting with parsnip” article contains
\href{https://parsnip.tidymodels.org/articles/articles/Examples.html#logistic-reg-keras}{examples}
for \code{logistic_reg()} with the \code{"keras"} engine.
}

\subsection{References}{
\itemize{
\item Hoerl, A., & Kennard, R. (2000). \emph{Ridge Regression: Biased
Estimation for Nonorthogonal Problems}. Technometrics, 42(1), 80-86.
}
}
}
\keyword{internal}
