% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.glht.R
\name{model_parameters.glht}
\alias{model_parameters.glht}
\title{Parameters from Hypothesis Testing}
\usage{
\method{model_parameters}{glht}(model, ci = 0.95, exponentiate = FALSE, ...)
}
\arguments{
\item{model}{Object of class \code{\link[multcomp:glht]{glht}} (\pkg{multcomp}).}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the the coefficients (and related confidence intervals). This is typical for, say, logistic regressions, or more generally speaking: for models with log or logit link. \strong{Note:} standard errors are also transformed (by multiplying the standard errors with the exponentiated coefficients), to mimic behaviour of other software packages, such as Stata.}

\item{...}{Arguments passed to or from other methods. For instance, when \code{bootstrap = TRUE}, arguments like \code{ci_method} are passed down to \code{\link[bayestestR]{describe_posterior}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from Hypothesis Testing.
}
\examples{
\donttest{
if (require("multcomp")) {
  # multiple linear model, swiss data
  lmod <- lm(Fertility ~ ., data = swiss)
  mod <- glht(
    model = lmod,
    linfct = c(
      "Agriculture = 0",
      "Examination = 0",
      "Education = 0",
      "Catholic = 0",
      "Infant.Mortality = 0"
    )
  )
  model_parameters(mod)
}
}
}
