% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_parameters.R
\name{model_parameters}
\alias{model_parameters}
\alias{parameters}
\title{Model Parameters}
\usage{
model_parameters(model, ...)

parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods. Non-documented
arguments are \code{digits}, \code{p_digits}, \code{ci_digits} and
\code{footer_digits} to set the number of digits for the output.
\code{group} can also be passed to the \code{print()} method. See details
in \code{\link[=print.parameters_model]{print.parameters_model()}} and 'Examples' in
\code{\link[=model_parameters.default]{model_parameters.default()}}.}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Compute and extract model parameters. See the documentation for your object's class:
\itemize{
\item{\link[=model_parameters.htest]{Correlations, t-tests, ...} (\code{htest}, \code{pairwise.htest})}
\item{\link[=model_parameters.aov]{ANOVAs} (\code{aov}, \code{anova}, \strong{afex}, ...)}
\item{\link[=model_parameters.default]{Regression models} (\code{lm}, \code{glm}, \strong{survey}, ...)}
\item{\link[=model_parameters.merMod]{Mixed models} (\strong{lme4}, \strong{nlme}, \strong{glmmTMB}, \strong{afex}, ...)}
\item{\link[=model_parameters.cgam]{Additive models} (\code{gam}, \code{gamm}, ...)}
\item{\link[=model_parameters.zcpglm]{Zero-inflated models} (\code{hurdle}, \code{zeroinfl}, \code{zerocount})}
\item{\link[=model_parameters.mlm]{Multinomial, ordinal and cumulative link models} (\code{bracl}, \code{multinom}, \code{mlm}, \strong{ordinal}, ...)}
\item{\link[=model_parameters.averaging]{Other special models} (\code{model.avg}, \code{betareg}, \code{glmx}, ...)}
\item{\link[=model_parameters.BFBayesFactor]{Bayesian tests} (\strong{BayesFactor})}
\item{\link[=model_parameters.stanreg]{Bayesian models} (\strong{rstanarm}, \strong{brms}, \strong{MCMCglmm}, \strong{blavaan}, ...)}
\item{\link[=model_parameters.principal]{PCA and FA} (\strong{psych})}
\item{\link[=model_parameters.lavaan]{CFA and SEM} (\strong{lavaan})}
\item{\link[=model_parameters.kmeans]{Cluster models} (k-means, ...)}
\item{\link[=model_parameters.rma]{Meta-Analysis via linear (mixed) models} (\code{rma}, \code{metaplus}, \strong{metaBMA}, ...)}
\item{\link[=model_parameters.glht]{Hypothesis testing} (\code{glht}, \strong{PMCMRplus})}
\item{\link[=model_parameters.t1way]{Robust statistical tests} (\strong{WRS2})}
\item{\link[=model_parameters.mira]{Multiply imputed repeated analyses} (\code{mira})}
}
}
\note{
The \code{\link[=print.parameters_model]{print()}} method has several
arguments to tweak the output. There is also a
\href{https://easystats.github.io/see/articles/parameters.html}{\code{plot()}-method}
implemented in the
\href{https://easystats.github.io/see/}{\strong{see}-package}, and a dedicated
method for use inside rmarkdown files,
\code{\link[=print_md.parameters_model]{print_md()}}. \cr \cr \strong{For developers}, if
speed performance is an issue, you can use the (undocumented) \code{pretty_names}
argument, e.g. \code{model_parameters(..., pretty_names = FALSE)}. This will
skip the formatting of the coefficient names and make \code{model_parameters()}
faster.
}
\section{Standardization of model coefficients}{

Standardization is based on \code{\link[=standardize_parameters]{standardize_parameters()}}. In case
of \code{standardize = "refit"}, the data used to fit the model will be
standardized and the model is completely refitted. In such cases, standard
errors and confidence intervals refer to the standardized coefficient. The
default, \code{standardize = "refit"}, never standardizes categorical predictors
(i.e. factors), which may be a different behaviour compared to other R
packages or other software packages (like SPSS). To mimic behaviour of SPSS
or packages such as \strong{lm.beta}, use \code{standardize = "basic"}.
}

\section{Standardization Methods}{

\itemize{
\item \strong{refit}: This method is based on a complete model re-fit with a
standardized version of the data. Hence, this method is equal to
standardizing the variables before fitting the model. It is the "purest" and
the most accurate (Neter et al., 1989), but it is also the most
computationally costly and long (especially for heavy models such as Bayesian
models). This method is particularly recommended for complex models that
include interactions or transformations (e.g., polynomial or spline terms).
The \code{robust} (default to \code{FALSE}) argument enables a robust standardization
of data, i.e., based on the \code{median} and \code{MAD} instead of the \code{mean} and
\code{SD}. \strong{See \code{\link[=standardize]{standardize()}} for more details.}
\strong{Note} that \code{standardize_parameters(method = "refit")} may not return
the same results as fitting a model on data that has been standardized with
\code{standardize()}; \code{standardize_parameters()} used the data used by the model
fitting function, which might not be same data if there are missing values.
see the \code{remove_na} argument in \code{standardize()}.
\item \strong{posthoc}: Post-hoc standardization of the parameters, aiming at
emulating the results obtained by "refit" without refitting the model. The
coefficients are divided by the standard deviation (or MAD if \code{robust}) of
the outcome (which becomes their expression 'unit'). Then, the coefficients
related to numeric variables are additionally multiplied by the standard
deviation (or MAD if \code{robust}) of the related terms, so that they correspond
to changes of 1 SD of the predictor (e.g., "A change in 1 SD of \code{x} is
related to a change of 0.24 of the SD of \code{y}). This does not apply to binary
variables or factors, so the coefficients are still related to changes in
levels. This method is not accurate and tend to give aberrant results when
interactions are specified.
\item \strong{basic}: This method is similar to \code{method = "posthoc"}, but treats all
variables as continuous: it also scales the coefficient by the standard
deviation of model's matrix' parameter of factors levels (transformed to
integers) or binary predictors. Although being inappropriate for these cases,
this method is the one implemented by default in other software packages,
such as \code{\link[lm.beta:lm.beta]{lm.beta::lm.beta()}}.
\item \strong{smart} (Standardization of Model's parameters with Adjustment,
Reconnaissance and Transformation - \emph{experimental}): Similar to \code{method = "posthoc"} in that it does not involve model refitting. The difference is
that the SD (or MAD if \code{robust}) of the response is computed on the relevant
section of the data. For instance, if a factor with 3 levels A (the
intercept), B and C is entered as a predictor, the effect corresponding to B
vs. A will be scaled by the variance of the response at the intercept only.
As a results, the coefficients for effects of factors are similar to a Glass'
delta.
\item \strong{pseudo} (\emph{for 2-level (G)LMMs only}): In this (post-hoc) method, the
response and the predictor are standardized based on the level of prediction
(levels are detected with \code{\link[performance:check_heterogeneity_bias]{performance::check_heterogeneity_bias()}}): Predictors
are standardized based on their SD at level of prediction (see also
\code{\link[datawizard:demean]{datawizard::demean()}}); The outcome (in linear LMMs) is standardized based
on a fitted random-intercept-model, where \code{sqrt(random-intercept-variance)}
is used for level 2 predictors, and \code{sqrt(residual-variance)} is used for
level 1 predictors (Hoffman 2015, page 342). A warning is given when a
within-group variable is found to have access between-group variance.
}
}

\section{Labeling the Degrees of Freedom}{

Throughout the \strong{parameters} package, we decided to label the residual
degrees of freedom \emph{df_error}. The reason for this is that these degrees
of freedom not always refer to the residuals. For certain models, they refer
to the estimate error - in a linear model these are the same, but in - for
instance - any mixed effects model, this isn't strictly true. Hence, we
think that \code{df_error} is the most generic label for these degrees of
freedom.
}

\section{Confidence intervals and approximation of degrees of freedom}{

There are different ways of approximating the degrees of freedom depending
on different assumptions about the nature of the model and its sampling
distribution. The \code{ci_method} argument modulates the method for computing degrees
of freedom (df) that are used to calculate confidence intervals (CI) and the
related p-values. Following options are allowed, depending on the model
class:

\strong{Classical methods:}

Classical inference is generally based on the \strong{Wald method}.
The Wald approach to inference computes a test statistic by dividing the
parameter estimate by its standard error (Coefficient / SE),
then comparing this statistic against a t- or normal distribution.
This approach can be used to compute CIs and p-values.

\code{"wald"}:
\itemize{
\item Applies to \emph{non-Bayesian models}. For \emph{linear models}, CIs
computed using the Wald method (SE and a \emph{t-distribution with residual df});
p-values computed using the Wald method with a \emph{t-distribution with residual df}.
For other models, CIs computed using the Wald method (SE and a \emph{normal distribution});
p-values computed using the Wald method with a \emph{normal distribution}.
}

\code{"normal"}
\itemize{
\item Applies to \emph{non-Bayesian models}. Compute Wald CIs and p-values,
but always use a normal distribution.
}

\code{"residual"}
\itemize{
\item Applies to \emph{non-Bayesian models}. Compute Wald CIs and p-values,
but always use a \emph{t-distribution with residual df} when possible. If the
residual df for a model cannot be determined, a normal distribution is
used instead.
}

\strong{Methods for mixed models:}

Compared to fixed effects (or single-level) models, determining appropriate
df for Wald-based inference in mixed models is more difficult.
See \href{https://bbolker.github.io/mixedmodels-misc/glmmFAQ.html#what-are-the-p-values-listed-by-summaryglmerfit-etc.-are-they-reliable}{the R GLMM FAQ}
for a discussion.

Several approximate methods for computing df are available, but you should
also consider instead using profile likelihood (\code{"profile"}) or bootstrap ("\verb{boot"})
CIs and p-values instead.

\code{"satterthwaite"}
\itemize{
\item Applies to \emph{linear mixed models}. CIs computed using the
Wald method (SE and a \emph{t-distribution with Satterthwaite df}); p-values
computed using the Wald method with a \emph{t-distribution with Satterthwaite df}.
}

\code{"kenward"}
\itemize{
\item Applies to \emph{linear mixed models}. CIs computed using the Wald
method (\emph{Kenward-Roger SE} and a \emph{t-distribution with Kenward-Roger df});
p-values computed using the Wald method with \emph{Kenward-Roger SE and t-distribution with Kenward-Roger df}.
}

\code{"ml1"}
\itemize{
\item Applies to \emph{linear mixed models}. CIs computed using the Wald
method (SE and a \emph{t-distribution with m-l-1 approximated df}); p-values
computed using the Wald method with a \emph{t-distribution with m-l-1 approximated df}.
See \code{\link[=ci_ml1]{ci_ml1()}}.
}

\code{"betwithin"}
\itemize{
\item Applies to \emph{linear mixed models} and \emph{generalized linear mixed models}.
CIs computed using the Wald method (SE and a \emph{t-distribution with between-within df});
p-values computed using the Wald method with a \emph{t-distribution with between-within df}.
See \code{\link[=ci_betwithin]{ci_betwithin()}}.
}

\strong{Likelihood-based methods:}

Likelihood-based inference is based on comparing the likelihood for the
maximum-likelihood estimate to the the likelihood for models with one or more
parameter values changed (e.g., set to zero or a range of alternative values).
Likelihood ratios for the maximum-likelihood and alternative models are compared
to a \eqn{\chi}-squared distribution to compute CIs and p-values.

\code{"profile"}
\itemize{
\item Applies to \emph{non-Bayesian models} of class \code{glm}, \code{polr} or \code{glmmTMB}.
CIs computed by \emph{profiling the likelihood curve for a parameter}, using
linear interpolation to find where likelihood ratio equals a critical value;
p-values computed using the Wald method with a \emph{normal-distribution} (note:
this might change in a future update!)
}

\code{"uniroot"}
\itemize{
\item Applies to \emph{non-Bayesian models} of class \code{glmmTMB}. CIs
computed by \emph{profiling the likelihood curve for a parameter}, using root
finding to find where likelihood ratio equals a critical value; p-values
computed using the Wald method with a \emph{normal-distribution} (note: this
might change in a future update!)
}

\strong{Methods for bootstrapped or Bayesian models:}

Bootstrap-based inference is based on \strong{resampling} and refitting the model
to the resampled datasets. The distribution of parameter estimates across
resampled datasets is used to approximate the parameter's sampling
distribution. Depending on the type of model, several different methods for
bootstrapping and constructing CIs and p-values from the bootstrap
distribution are available.

For Bayesian models, inference is based on drawing samples from the model
posterior distribution.

\code{"quantile"} (or \code{"eti"})
\itemize{
\item Applies to \emph{all models (including Bayesian models)}.
For non-Bayesian models, only applies if \code{bootstrap = TRUE}. CIs computed
as \emph{equal tailed intervals} using the quantiles of the bootstrap or
posterior samples; p-values are based on the \emph{probability of direction}.
See \code{\link[bayestestR:eti]{bayestestR::eti()}}.
}

\code{"hdi"}
\itemize{
\item Applies to \emph{all models (including Bayesian models)}. For non-Bayesian
models, only applies if \code{bootstrap = TRUE}. CIs computed as \emph{highest density intervals}
for the bootstrap or posterior samples; p-values are based on the \emph{probability of direction}.
See \code{\link[bayestestR:hdi]{bayestestR::hdi()}}.
}

\code{"bci"} (or \code{"bcai"})
\itemize{
\item Applies to \emph{all models (including Bayesian models)}.
For non-Bayesian models, only applies if \code{bootstrap = TRUE}. CIs computed
as \emph{bias corrected and accelerated intervals} for the bootstrap or
posterior samples; p-values are based on the \emph{probability of direction}.
See \code{\link[bayestestR:bci]{bayestestR::bci()}}.
}

\code{"si"}
\itemize{
\item Applies to \emph{Bayesian models} with proper priors. CIs computed as
\emph{support intervals} comparing the posterior samples against the prior samples;
p-values are based on the \emph{probability of direction}. See \code{\link[bayestestR:si]{bayestestR::si()}}.
}

\code{"boot"}
\itemize{
\item Applies to \emph{non-Bayesian models} of class \code{merMod}. CIs computed
using \emph{parametric bootstrapping} (simulating data from the fitted model);
p-values computed using the Wald method with a \emph{normal-distribution)}
(note: this might change in a future update!).
}

For all iteration-based methods other than \code{"boot"}
(\code{"hdi"}, \code{"quantile"}, \code{"ci"}, \code{"eti"}, \code{"si"}, \code{"bci"}, \code{"bcai"}),
p-values are based on the probability of direction (\code{\link[bayestestR:p_direction]{bayestestR::p_direction()}}),
which is converted into a p-value using \code{\link[bayestestR:pd_to_p]{bayestestR::pd_to_p()}}.
}

\section{Interpretation of Interaction Terms}{

Note that the \emph{interpretation} of interaction terms depends on many
characteristics of the model. The number of parameters, and overall
performance of the model, can differ \emph{or not} between \code{a * b}
\code{a : b}, and \code{a / b}, suggesting that sometimes interaction terms
give different parameterizations of the same model, but other times it gives
completely different models (depending on \code{a} or \code{b} being factors
of covariates, included as main effects or not, etc.). Their interpretation
depends of the full context of the model, which should not be inferred
from the parameters table alone - rather, we recommend to use packages
that calculate estimated marginal means or marginal effects, such as
\CRANpkg{modelbased}, \CRANpkg{emmeans} or \CRANpkg{ggeffects}. To raise
awareness for this issue, you may use \code{print(...,show_formula=TRUE)}
to add the model-specification to the output of the
\code{\link[=print.parameters_model]{print()}} method for \code{model_parameters()}.
}

\references{
\itemize{
\item Hoffman, L. (2015). Longitudinal analysis: Modeling within-person
fluctuation and change. Routledge.
\item Neter, J., Wasserman, W., & Kutner, M. H. (1989). Applied linear
regression models.
}
}
\seealso{
\code{\link[insight:standardize_names]{insight::standardize_names()}} to
rename columns into a consistent, standardized naming scheme.
}
