% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.R
\name{model_parameters}
\alias{model_parameters}
\title{Model Parameters}
\usage{
model_parameters(model, ...)
}
\arguments{
\item{model}{Statistical Model.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data.frame of indices related to the model's parameters.
}
\description{
Compute and extract model parameters. See the documentation for your object's class:
\itemize{
 \item{\link[=model_parameters.htest]{Correlations and t-tests}}
 \item{\link[=model_parameters.aov]{ANOVAs}}
 \item{\link[=model_parameters.lm]{Frequentist regressions} (\code{lm}, \code{glm})}
 \item{\link[=model_parameters.merMod]{Frequentist mixed models} (\code{lme4})}
 \item{\link[=model_parameters.stanreg]{Bayesian models} (\code{rstanarm}, \code{brms})}
 \item{\link[=model_parameters.principal]{PCA and FA} (\code{psych})}
 \item{\link[=model_parameters.lavaan]{CFA and SEM} (\code{lavaan})}
 }
}
