% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_gradient.R
\name{parafac_gradient}
\alias{parafac_gradient}
\title{Calculate gradient of PARAFAC model.}
\usage{
parafac_gradient(x, Tensor)
}
\arguments{
\item{x}{Vector of fitted loadings generated by the PARAFAC algorithm, can also be a Fac object}

\item{Tensor}{input data}
}
\value{
Gradient of the PARAFAC model.
}
\description{
Calculate gradient of PARAFAC model.
}
\examples{
A = array(rnorm(108*2), c(108,2))
B = array(rnorm(100*2), c(100,2))
C = array(rnorm(10*2), c(10,2))
X = reinflateTensor(A, B, C)
init = initializePARAFAC(X, 2)
g = parafac_gradient(init, X)
}
