% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bathy.R
\name{bathy_deep_pal}
\alias{bathy_deep_pal}
\alias{bathyDeepPal}
\title{Bathymetry}
\usage{
bathy_deep_pal(x, palette = FALSE, alpha = 1, ...)

bathyDeepPal(x, palette = FALSE, alpha = 1, ...)
}
\arguments{
\item{x}{a vector of data values or a single num (n)}

\item{palette}{logical, if \code{TRUE} return a list with matching colours and values}

\item{alpha}{value in 0,1 to specify opacity}

\item{...}{currently ignored}
}
\value{
colours, palette, or function, see Details
}
\description{
Deep bathymetry colours.
}
\details{
Colour ramp suitable for deep waters (-5500) to sea level.
The palette functions operate in 3 modes:
1) n colours - Pal(6) - returns 6 colours from the palette
2) data      - Pal(c(10, 50, 100)) - return colours for 3 ice concentrations
3) palette   - Pal(palette = TRUE) - return the full palette and breaks
Derived from maps created in Matlab by Emmanuel Laurenceau.
}
\examples{
plot(1:15, pch = 19, cex = 4, col  = bathy_deep_pal(15))
}
