% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot.kdffreq}
\alias{plot.kdffreq}
\title{plot.kdffreq}
\usage{
\method{plot}{kdffreq}(x, ylim = NULL, xlim = NULL, ...)
}
\arguments{
\item{x}{Object returned by kdffreq}

\item{xlim}{Numeric x axis limits}

\item{ylim}{Numeric, y axis limits}

\item{...}{other arguments}
}
\description{
Plot fire frequency calculated using the \code{\link[paleofire]{kdffreq}} function
}
\examples{
set.seed(123)
 fevent=c(round(abs(rnorm(20,mean=7,sd=5))*1000),round(abs(rnorm(10,mean=8,sd=1))*1000))

 ff=kdffreq(fevent,bandwidth = 1000, nbboot=10)
 plot(ff)
}
\seealso{
\code{\link[paleofire]{kdffreq}}
}

