% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.r
\name{as_paf}
\alias{as_paf}
\title{Coerce a data.frame or tibble into a pafr object}
\usage{
as_paf(paf_data_frame)
}
\arguments{
\item{paf_data_frame}{a data.frame object with 12 columns. Column names and
types will be over-written in the returned object}
}
\value{
a pafr object
}
\description{
The main reason to use this function is speed up the process of reading in
a large paf file that has no tags. Functions like read.table, read_delim
(reader) and fread (data.table) can process a 12 column file  more quickly
than pafr's read_paf. If you you do not need tag data for your analyses or
visualizations, it might make sense to use a fast reading function to get a
12 column data.frame,  convert that data.frame into a `pafr  object with this
function. The `pafr` object can then work easily with the functions in this package.
}
\seealso{
read_paf
}
