% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{app_deps}
\alias{app_deps}
\title{The shiny app dependencies}
\usage{
app_deps(
  path = ".",
  fields = c("Depends", "Imports", "LinkingTo"),
  lib.loc = .libPaths(),
  local = TRUE,
  description_v = FALSE,
  recursive = TRUE,
  repos = biocran_repos()
)
}
\arguments{
\item{path}{path to the shiny app. Default: \code{"."}}

\item{fields}{a character vector listing the types of dependencies, a subset of c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances").
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lib.loc}{character vector, used optionally when local is equal TRUE. Default: \code{.libPaths()}}

\item{local}{logical if to use local repository or newest CRAN packages, where by default local packages are used. Default: TRUE}

\item{description_v}{if the dependencies version should be taken from description files, minimal required. By default installed versions are taken. Default: FALSE}

\item{recursive}{logical if to assess the dependencies recursively. Default: TRUE}

\item{repos}{character the base URL of the CRAN repository to use. Used only for the validation. Default \code{pacs::biocran_repos()}}
}
\value{
character vector with dependency packages or data.frame when checking recursively.
}
\description{
the shiny app dependencies packages are checked recursively.
The \code{c("Depends", "Imports", "LinkingTo")} DESCRIPTION files fields are checked recursively.
The required dependencies have to be installed in the local repository.
The default arguments setup is recommended.
}
\note{
the base packages are not taken into account.
}
\examples{
\dontrun{
# Please update the path to the custom shiny app
app_path <- system.file("examples/04_mpg", package = "shiny")
pacs::app_deps(app_path)
pacs::app_deps(app_path, recursive = FALSE)
}
}
