% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{lib_validate}
\alias{lib_validate}
\title{Validate the library.}
\usage{
lib_validate(
  lib.loc = NULL,
  fields = c("Depends", "Imports", "LinkingTo"),
  lifeduration = FALSE,
  checkred = FALSE
)
}
\arguments{
\item{lib.loc}{character. Default: NULL}

\item{fields}{character vector with possible values \code{c("Depends", "Imports", "LinkingTo", "Suggests")}. Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lifeduration}{logical if to add life duration column, might take some time. Default: FALSE}

\item{checkred}{logical if to add R CRAN check page status, any WARNING or ERROR will give TRUE. Default FALSE}
}
\value{
data.frame with 5/6/7 columns.
\describe{
\item{Package}{character package names.}
\item{Version.expected.min}{character expected by DESCRIPTION files minimal version. "" means not specified so the newest version.}
\item{Version.have}{character installed package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
\item{life_duration}{(Optional) integer number of days package was released.}
\item{newest}{ logical if the installed version is the newest one.}
\item{checkred}{(Optional) logical if the newest package contains any errors or warnings on CRAN check page.}
}
}
\description{
Compare current and expected packages under \code{.libPaths}.
Checking the healthy of the library, which packages are newest one.
Optionally added life duration of each package.
}
\note{
Version.expected.min column not count packages which are not a dependency for any package, so could not be find in DESCRIPTION files.
When turn on the \code{lifeduration} and/or \code{checkred} options, calculations might be time consuming.
Please as a courtesy to the R CRAN, don't overload their server by constantly using this function with \code{lifeduration} or \code{checkred} turned on.
Results are cached for 1 hour with \code{memoise} package, memory cache.
}
\examples{
lib_validate()

}
