% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/install_github.R
\name{install_github}
\alias{install_github}
\title{Install a package from GitHub}
\usage{
install_github(repo, ..., build_vignettes = FALSE, dependencies = NA)
}
\arguments{
\item{repo}{Repository address in the format
\code{[username/]repo[/subdir][@ref|#pull]}. Alternatively, you can
specify \code{username}, \code{subdir}, \code{ref} or \code{pull} using the
respective parameters.}

\item{...}{Other arguments passed on to
\code{\link[devtools:install_github]{devtools::install_github}}.}

\item{build_vignettes}{If \code{TRUE}, will build the package's vignettes
(default to \code{FALSE} for faster in)}

\item{dependencies}{\code{NA} (the default) has the same behavior as
  \code{install.packages} (installs "Depends", "Imports", and "LinkingTo").
  See the documentation for
  \code{\link[utils:install.packages]{install.packages}} for details on other
  valid arguments.}
}
\description{
Use the \code{\link[devtools:install_github]{devtools::install_github}}
function to install packages into a project private library. Using this
function rather than calling devtools directly enables you to install GitHub
packages without adding devtools and it's dependencies to your project
private library.
}
\note{
This function requires the \pkg{devtools} package and will prompt to
to install it if it's not already available in the standard library paths.
In this case, devtools will be installed into the standard user package
library rather than the project private library.
}

