% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_lines.R
\name{remove_lines}
\alias{remove_lines}
\title{Remove Lines From a File}
\usage{
remove_lines(
  file_path = file.path(".", ".gitignore"),
  pattern,
  overwrite = !isFALSE(getOption("packager")[["force"]])
)
}
\arguments{
\item{file_path}{Path to the file.}

\item{pattern}{A character vector of patterns.}

\item{overwrite}{Overwrite the file on disk?}
}
\value{
Used for its side effects, returns the lines to be left in the file.
}
\description{
Delete lines from a files programmatically, for example from
\file{.gitignore}.
}
\examples{
temp_file <- file.path(tempdir(), ".gitignore")
content <- c("doc", "Meta", ".RData", "*.tar.gz", "doc/*")
cat(content, sep = "\n")
writeLines(content, temp_file)
cat(remove_lines(temp_file,  c("^doc$", "^doc/.*$")), sep = "\n")
cat(readLines(temp_file), sep = "\n")
}
\keyword{internal}
