% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageRankTime.R
\name{plot.package_rank_time}
\alias{plot.package_rank_time}
\title{Plot method for timeSeriesRank().}
\usage{
\method{plot}{package_rank_time}(x, graphics_pkg = "ggplot2",
  log_count = TRUE, pkg_smooth = TRUE, sample_smooth = TRUE,
  f = 1/3, ...)
}
\arguments{
\item{x}{Object. An object of class "time_series" created by \code{packageRankTime()}.}

\item{graphics_pkg}{Character. "base" or "ggplot2".}

\item{log_count}{Logical. Logarithm of package downloads.}

\item{pkg_smooth}{Logical. Add smoother.}

\item{sample_smooth}{Logical. lowess background.}

\item{f}{Numeric. stats::lowess() smoother window. For use with graphics_pkg = "base" only.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R or ggplot2 plot.
}
\description{
Plot method for timeSeriesRank().
}
\examples{
\donttest{

plot(packageRankTime(packages = "HistData", when = "last-week"))
plot(packageRankTime(packages = c("Rcpp", "rlang", "data.table"), when = "last-month"))
}
}
