% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2b_parameter_estimation_survival_functions.R
\name{use_parametric_survival}
\alias{use_parametric_survival}
\title{###########################################################################
Get the parameter values using the survival analysis parametric survival}
\usage{
use_parametric_survival(
  param_to_be_estimated,
  dataset,
  indep_var,
  info_distribution,
  covariates,
  timevar_survival
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{dataset}{data set to be provided}

\item{indep_var}{the independent variable (column name in data file)}

\item{info_distribution}{distribution name  eg. for logistic
regression -binomial}

\item{covariates}{list of covariates}

\item{timevar_survival}{time variable for survival analysis,
default is NA}
}
\value{
the results of the regression analysis
}
\description{
###########################################################################
Get the parameter values using the survival analysis parametric survival
}
\details{
This function is the last in the layer of function for parametric
survival analysis. This then returns the parameters of interest, plots
the results etc if the distribution is weibull it uses the package
SurvRegCensCov for easy interpretation of results
Returns the fit result, summary of regression, variance-covariance
matrix of coeff, cholesky decomposition, the parameters that define the
assumed distribution and the plot of model prediction
Using survfit from survival package to plot the survival curve
R's weibull distribution is defined as std weibull in terms of a and b
as (a/b) (x/b)^ (a-1) exp((-x/b)^a) where a is the shape and b is the scale
In HE the weibull distribution is parameterised as bit different
it is like gamma.lambda. t^(gamma-1) .exp(-lambda*t^gamma) where
gamma is the shape and lambda is the scale. The relationship is as below.
HE_shape = rweibull_shape
HE_scale = rweibull_scale ^(-rweibull_shape)
The survreg shape and scale are again bit different and they are
rweibull's shape and scale as below.
rweibull_shape = 1/fit$scale
rweibull_scale = exp(fit intercept)= exp(fit$coefficients)
remember to use 1st of coefficients
This has been utilised in SurvRegCensCov::ConvertWeibull
predict() for survreg object with type =quantile will provide
the failure times as survival function is 1-CDF of failure time.
}
\examples{
\donttest{
data_for_survival <- survival::lung
surv_estimated <- use_parametric_survival("status",
data_for_survival, "sex", info_distribution = "weibull",
covariates = c("ph.ecog"), "time")
}
}
