% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data.R
\name{download_data}
\alias{download_data}
\title{Download various precipitation data products}
\usage{
download_data(
  dataset = "all",
  path = ".",
  domain = "raw",
  timestep = "monthly"
)
}
\arguments{
\item{dataset}{a character string with the name(s) of the desired data set. Suitable options are:
\itemize{
\item{"all" for all of the below listed data sets (default),}
\item{"20cr" for 20CR v3,}
\item{"chirps" for CHIRPS v2.0,}
\item{"cmap" for CMAP standard version,}
\item{"cmorph" for CMORPH,}
\item{"cpc" for CPC-Global,}
\item{"cru-ts" for CRU_TS v4.06,}
\item{"em-earth" for EM-EARTH,}
\item{"era20c" for ERA-20C,}
\item{"era5" for ERA5,}
\item{"fldas" for FLDAS,}
\item{"ghcn" for GHCN-M v2,}
\item{"gldas-clsm" for GLDAS CLSM,}
\item{"gldas-noah" for GLDAS NOAH,}
\item{"gldas-vic" for GLDAS VIC,}
\item{"gpcc" for GPCC v2020,}
\item{"gpcp" for GPCP v2.3,}
\item{"gpm_imerg" for GPM IMERGM Final v06,}
\item{"jra55" for JRA-55,}
\item{"merra2" for MERRA-2,}
\item{"mswep" for MSWEP v2.8,}
\item{"ncep-doe" for NCEP/DOE,}
\item{"ncep-ncar" for NCEP/NCAR,}
\item{"persiann" for PERSIANN-CDR,}
\item{"precl" for PREC/L,}
\item{"terraclimate" for TerraClimate,}
\item{"trmm-3b43" for TRMM 3B43 v7,}
\item{"udel" for UDEL v501.}
}}

\item{path}{a character string with the path where the database will be downloaded.}

\item{domain}{a character string with the desired domain data set. Suitable options are:
\itemize{
\item{"raw" for default available spatial coverage,}
\item{"global" for data sets with global (land and ocean) coverage,}
\item{"land" for data sets with land only coverage,}
\item{"ocean", for data sets with ocean only coverage.}
}}

\item{timestep}{a character string with the desired time resolution. Suitable options are:
\itemize{
\item{"monthly",}
\item{"yearly".}
}}
}
\value{
No return value, called to download the required data sets.
}
\description{
The function \code{download_data} downloads the selected data product.
}
\examples{
\donttest{
download_data("gldas-vic", tempdir(), timestep = "yearly")
}
}
