% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owid_plot.R
\name{owid_plot}
\alias{owid_plot}
\title{Plot an owid dataset}
\usage{
owid_plot(
  data = NULL,
  col = 4,
  summarise = TRUE,
  filter = NULL,
  years = NULL,
  show.all = FALSE
)
}
\arguments{
\item{data}{A tibble returned from \code{owid()}}

\item{col}{Either the column number to be treated as the value or a character string specifying the name of the value column. Defaults to 3, which is the first possible value column.}

\item{summarise}{A logical value. If TRUE, plot takes the mean value. If FALSE, each entity is plotted, it is recommended to use this in conjunction with the filter argument to avoid too many entity's being plotted.}

\item{filter}{The entity's to include in the plot.}

\item{years}{The years to be included in the plot.}

\item{show.all}{A logical value indicating weather all entities should be included in the plot.}
}
\value{
A ggplot object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function was deprecated to simplify the owidR package, you are encouraged to use ggplot2 instead: https://ggplot2-book.org
}
\examples{

human_rights <- owid("human-rights-scores")

# use ggplot2 instead
library(ggplot2)
library(dplyr)

human_rights |>
  filter(entity == "United Kingdom") |>
  ggplot(aes(year, `Human rights protection`)) +
  geom_line()


}
\keyword{internal}
