% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overview_crossplot.R
\name{overview_crossplot}
\alias{overview_crossplot}
\title{overview_crossplot}
\usage{
overview_crossplot(
  dat,
  id,
  time,
  cond1,
  cond2,
  threshold1,
  threshold2,
  xaxis = "Condition 1",
  yaxis = "Condition 2",
  label = FALSE,
  color = FALSE
)
}
\arguments{
\item{dat}{Your data set}

\item{id}{Your scope (e.g., country codes or individual IDs). If the id
variable contains NAs, they will not be included in the plot.}

\item{time}{Your time (e.g., time periods given by years, months, ...)}

\item{cond1}{Variable that describes the first condition}

\item{cond2}{Variable that describes the second condition}

\item{threshold1}{A threshold for \code{cond1}}

\item{threshold2}{A threshold for \code{cond2}}

\item{xaxis}{Label of the x axis ("Condition 1" is default)}

\item{yaxis}{Label of the y axis ("Condition 2" is default)}

\item{label}{Label of the observations. Overlapping labels are
avoided by using 'ggrepel'}

\item{color}{Color of the different observation groups}
}
\value{
A ggplot figure that presents the sample information visually
    in a cross table
}
\description{
This function plots a ggplot to visualize a cross table plot.
}
\examples{
data(toydata)
overview_crossplot(
  dat = toydata,
  cond1 = gdp,
  cond2 = population,
  threshold1 = 25000,
  threshold2 = 27000,
  id = ccode,
  time = year
)
}
