% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{log_set}
\alias{log_set}
\title{Set log streams for console output}
\usage{
log_set(log, val)
}
\arguments{
\item{log}{Output stream one of program_out, program_err, docker_out or
docker_err}

\item{val}{Either logical, file or connection.}
}
\description{
Set if and where to send the console streams of the outsider
modules.
}
\details{
See `sys::exec`.
}
\examples{
\dontrun{
library(outsider.base)

# Manually install example module
# outsider.base contains the hello.world module in its package files
pkgnm <- 'om..hello.world'
mdl_flpth <- system.file('extdata', 'om..hello.world',
                         package = "outsider.base")
# install and import (outsider::module_install performs these tasks)
pkg_install(flpth = mdl_flpth)
image_install(pkgnm = pkgnm)
# (outsider::module_import performs this task)
hello_world <- utils::getFromNamespace(x = 'hello_world', ns = pkgnm)

# control the log stream
# send output to file
tmpfl <- tempfile()
log_set(log = 'program_out', val = tmpfl)
hello_world()
(readLines(con = tmpfl))
file.remove(tmpfl)
# send docker and program output to console
log_set(log = 'program_out', val = TRUE)
log_set(log = 'docker_out', val = TRUE)
hello_world()

# clean-up
uninstall(pkgnm)
}
}
\concept{user}
