% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_demographics.R
\name{dataset_demographics}
\alias{dataset_demographics}
\title{Returns the formatted demographic data set}
\usage{
dataset_demographics(
  module = c("All", "AAA", "BBB", "CCC", "DDD", "EEE", "FFF", "GGG"),
  presentation = c("2013B", "2014B", "2013J", "2014J", "All", "Summer", "Winter"),
  repeat_students = c("remove", "keep")
)
}
\arguments{
\item{module}{name of the module to be included, either \code{"All"}, \code{"AAA"}, \code{"BBB"}, \code{"CCC"}, \code{"DDD"}, \code{"EEE"}, \code{"FFF"} or \code{"GGG"}.}

\item{presentation}{name of the semester of the module to be included, either \code{"2013B"},
\code{"2014B"}, \code{"2013J"}, \code{"2014J"}, \code{"All"}, \code{"Summer"} or \code{"Winter"}.
\code{"B"} indicates a February start time whereas \code{"J"} indicates an October start time. \code{"All"} indicates
that all presentations of the module will be included in the returned data. \code{"Summer"} returns both \code{"2013B"} and \code{"2014B"}.
\code{"Winter"} returns both \code{"2013J"} and \code{"2014J"}.}

\item{repeat_students}{indicator of whether students who had previous attempts at the module should be removed, either \code{"remove"} or \code{"keep"}.}
}
\value{
Returns one \code{tibble} (object of class \code{tbl_df}), called 'studentInfo', based on the OULAD studentInfo.csv file
and the specified inputs (module, presentation, and repeat_students).

The \code{tibble} consists of 12 columns (Kuzilek et al., 2017):

\itemize{
\item{code_module - module identification code.}
\item{code_presentation - module presentation identification code.}
\item{id_student - the unique student identification number.}
\item{gender - student’s gender, either Male or Female.}
\item{region - the geographic region where the student lived while taking the module-presentation.}
\item{highest_education - the highest student education level on entry to the module presentation.}
\item{imd_band - the index of multiple deprivation band of the place where the student lived during the module-presentation.}
\item{age_band - a band of student’s age.}
\item{num_of_prev_attempts - the number of times the student has attempted this module previously.}
\item{studied_credits - the total number of credits for the modules the student is currently studying.}
\item{disability - indicates whether the student has declared a disability.}
\item{final_result - student’s final result in the module-presentation.}
}
}
\description{
Load and formats the student demographic data set from the OULAD for data analysis.
}
\examples{
dataset_demographics(module = "BBB", presentation = "2013J", repeat_students = "remove")
}
\references{
Kuzilek, J., Hlosta, M., & Zdrahal, Z. (2017). Open university learning analytics dataset. Scientific Data
volume 4 , (pp. 1–8). https://doi.org/10.1038/sdata.2017.171.
}
\seealso{
\code{\link[=combined_dataset]{combined_dataset()}}
}
