% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{PrepData}
\alias{PrepData}
\title{Prepare an input dataset for plotting}
\usage{
PrepData(dataFl, dateNm, selectCols = NULL, dropCols = NULL,
  dateFt = "\%d\%h\%Y", dateGp = NULL, dateGpBp = NULL, weightNm = NULL,
  varNms = NULL, dropConstants = FALSE, ...)
}
\arguments{
\item{dataFl}{Either the name of an object that can be converted using
\code{\link[data.table]{as.data.table}} (e.g., a data frame), or a 
character string containing the name of dataset that can be loaded using 
\code{\link[data.table]{fread}} (e.g., a csv file). If the dataset is not in 
your working directory then \code{dataFl} must include (relative or 
absolute) path to file.}

\item{dateNm}{Name of column containing the date variable.}

\item{selectCols}{Either \code{NULL}, or a vector of names or indices of 
variables to read into memory -- must include \code{dateNm}, 
\code{weightNm} (if not \code{NULL}) and all variables to be plotted. If
both \code{selectCols} and \code{dropCols} are \code{NULL}, then all
variables will be read in.}

\item{dropCols}{Either \code{NULL}, or a vector of variables names or indices
of variables not to read into memory. If both \code{selectCols} and 
\code{dropCols} are \code{NULL}, then all variables will be read in.}

\item{dateFt}{\code{\link{strptime}} format of date variable. The default is SAS
format \code{"\%d\%h\%Y"}. But input data with R date format 
\code{"\%Y-\%m-\%d"} will also be detected. Both of two formats can be
parsed automatically.}

\item{dateGp}{Name of the variable that the time series plots should be 
grouped by. Options are \code{NULL}, \code{"weeks"}, \code{"months"}, 
\code{"quarters"}, \code{"years"}. See \code{\link[data.table]{IDate}} for
details. If \code{NULL}, then \code{dateNm} will be used as \code{dateGp}.}

\item{dateGpBp}{Name of variable the boxplots should be grouped by. Same
options as \code{dateGp}. If \code{NULL}, then \code{dateGp} will be used.}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}

\item{varNms}{Either \code{NULL} or a vector of names or indices of variables
to be plotted. If \code{NULL}, will default to all columns which are not 
\code{dateNm} or \code{weightNm}. Can also be a vector of indices of the 
column names, after \code{dropCols} or \code{selectCols} have been applied,
if applicable, and not including \code{dateGp}, \code{dateGpBp} 
(which will be added to the \code{dataFl} by the function 
\code{\link{PrepData}}).}

\item{dropConstants}{Logical, indicates whether or not constant (all
duplicated or NA) variables should be dropped from \code{dataFl} prior to
plotting.}

\item{...}{Additional parameters to be passed to 
\code{\link[data.table]{fread}}.}
}
\value{
A \code{data.table} object, formatted for use by all plotting 
functions in this package \code{\link{otvPlots}}, including the main function
\code{\link{vlm}}, and the individual variable plotting function 
\code{\link{PlotVar}}.
}
\description{
This function prepares an input dataset for use by all plotting functions
in this package, including the main function \code{\link{vlm}}. 
The input data \code{dataFl} must contain, at a minimum, a date column 
\code{dateNm} and a variable to be plotted. \code{dataFl} will be 
converted to a \code{data.table} class, and all changes are made to it by 
reference.
}
\details{
If weights (\code{weightNm}) are provided, then it is normalized to have a
sum of weights equal the total sample size, and the weights are used in all 
summary statistics calculations and plotting.
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\examples{
## Use the bankData dataset in this package
data(bankData)
bankData <- PrepData(bankData, dateNm = "date", dateGp = "months", 
                     dateGpBp = "quarters")
## Columns have been assigned a plotting class (nmrcl/ctgrl)
str(bankData) 
}
\seealso{
Functions depend on this function:
         \code{\link{PlotBarplot}},
         \code{\link{PlotRatesOverTime}},
         \code{\link{PlotCatVar}},
         \code{\link{SummaryStats}},
         \code{\link{PlotMean}},
         \code{\link{PlotQuantiles}},
         \code{\link{PlotRates}},
         \code{\link{PlotDist}},
         \code{\link{PlotNumVar}},
         \code{\link{PlotVar}},
         \code{\link{PrintPlots}},
         \code{\link{CalcR2}},
         \code{\link{OrderByR2}},
         \code{\link{vlm}}.
}
