% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPS.R
\name{IPS}
\alias{IPS}
\title{The (S)IPS estimator.}
\usage{
IPS(eta, datalist, ps, t0, smooth = TRUE)
}
\arguments{
\item{eta}{The parameters of the regime.}

\item{datalist}{A list used to calculate the (S)IPS estimator including treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}. \code{\link[otrKM]{Fps.IPS}} can produce \code{ps} by positing logistic model.}

\item{ps}{A list including the probability of receiving treatment given baseline covariates named \code{fal}.}

\item{t0}{A predetermined time.}

\item{smooth}{A logic variable indicating wether a smoothed estimator should be used.}
}
\value{
Estimated potential survival probability given eta and t0.
}
\description{
Given a predetermined t0 and eta, calculate t0-year potential survival probability based on the (S)IPS estimator.
}
\details{
More details can be found in references.
}
\examples{
# load data
data(simulation)

# convert the data into a datalist
datalist=list(z=simulation$Instrument,a=simulation$Treatment,
              obs.t=simulation$Survival,delta=simulation$Status,
              l=cbind(simulation$Covariate1,simulation$Covariate2))

# calculate ps
ps=Fps.IPS(datalist)

# predetermined t0 and eta
t0=5
eta=c(1,2,3)

IPS(eta, datalist, ps, t0, smooth=TRUE)
}
\references{
{Jiang, R., Lu, W., Song, R., and Davidian, M. (2017) On estimation of optimal treatment regimes for maximizing t‐year survival probability. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, \bold{79:} 1165-1185. DOI:10.1111/rssb.12201}
}
