#ifndef UPDATE_MATRICES_DATA_H
#define UPDATE_MATRICES_DATA_H
#include "osqp.h"


/* create data and solutions structure */
typedef struct {
c_int test_form_KKT_n;
c_int test_form_KKT_m;
csc * test_form_KKT_A;
csc * test_form_KKT_Pu;
c_float test_form_KKT_rho;
c_float test_form_KKT_sigma;
csc * test_form_KKT_KKT;
csc * test_form_KKT_KKTu;
csc * test_form_KKT_A_new;
csc * test_form_KKT_Pu_new;
csc * test_form_KKT_KKT_new;
csc * test_form_KKT_KKTu_new;
csc * test_solve_Pu;
c_float * test_solve_q;
csc * test_solve_A;
c_float * test_solve_l;
c_float * test_solve_u;
c_int n;
c_int m;
c_float * test_solve_x;
c_float * test_solve_y;
c_float test_solve_obj_value;
c_int test_solve_status;
csc * test_solve_Pu_new;
c_float * test_solve_P_new_x;
c_float * test_solve_P_new_y;
c_float test_solve_P_new_obj_value;
c_int test_solve_P_new_status;
csc * test_solve_A_new;
c_float * test_solve_A_new_x;
c_float * test_solve_A_new_y;
c_float test_solve_A_new_obj_value;
c_int test_solve_A_new_status;
c_float * test_solve_P_A_new_x;
c_float * test_solve_P_A_new_y;
c_float test_solve_P_A_new_obj_value;
c_int test_solve_P_A_new_status;
} update_matrices_sols_data;

/* function prototypes */
update_matrices_sols_data *  generate_problem_update_matrices_sols_data();
void clean_problem_update_matrices_sols_data(update_matrices_sols_data * data);


/* function to define problem data */
update_matrices_sols_data *  generate_problem_update_matrices_sols_data(){

update_matrices_sols_data * data = (update_matrices_sols_data *)c_malloc(sizeof(update_matrices_sols_data));

data->test_form_KKT_n = 5;
data->test_form_KKT_m = 8;

// Matrix test_form_KKT_A
//-----------------------
data->test_form_KKT_A = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_A->m = 8;
data->test_form_KKT_A->n = 5;
data->test_form_KKT_A->nz = -1;
data->test_form_KKT_A->nzmax = 28;
data->test_form_KKT_A->x = (c_float*) c_malloc(28 * sizeof(c_float));
data->test_form_KKT_A->x[0] = 0.57730806879569795953;
data->test_form_KKT_A->x[1] = 0.50952587649232417011;
data->test_form_KKT_A->x[2] = 0.16782331070145573015;
data->test_form_KKT_A->x[3] = 0.79820038783705349328;
data->test_form_KKT_A->x[4] = 0.46784249347153428200;
data->test_form_KKT_A->x[5] = 0.94809042190270420569;
data->test_form_KKT_A->x[6] = 0.27417325939046011118;
data->test_form_KKT_A->x[7] = 0.22183516701270400429;
data->test_form_KKT_A->x[8] = 0.35367537868439535842;
data->test_form_KKT_A->x[9] = 0.14856478348934898381;
data->test_form_KKT_A->x[10] = 0.46867358416621918149;
data->test_form_KKT_A->x[11] = 0.76749117091526242174;
data->test_form_KKT_A->x[12] = 0.85228103372865227083;
data->test_form_KKT_A->x[13] = 0.79308974374262031226;
data->test_form_KKT_A->x[14] = 0.25873317142982743544;
data->test_form_KKT_A->x[15] = 0.99326629446159042658;
data->test_form_KKT_A->x[16] = 0.11948479832931302447;
data->test_form_KKT_A->x[17] = 0.31529748117286060527;
data->test_form_KKT_A->x[18] = 0.56576512922355526314;
data->test_form_KKT_A->x[19] = 0.82288464047648379740;
data->test_form_KKT_A->x[20] = 0.99085199519994981987;
data->test_form_KKT_A->x[21] = 0.36747136862384688349;
data->test_form_KKT_A->x[22] = 0.80917528597077170716;
data->test_form_KKT_A->x[23] = 0.21726992644012010913;
data->test_form_KKT_A->x[24] = 0.81413841308724066437;
data->test_form_KKT_A->x[25] = 0.65426618220709131801;
data->test_form_KKT_A->x[26] = 0.66306179305086021536;
data->test_form_KKT_A->x[27] = 0.61302969450978517241;
data->test_form_KKT_A->i = (c_int*) c_malloc(28 * sizeof(c_int));
data->test_form_KKT_A->i[0] = 0;
data->test_form_KKT_A->i[1] = 1;
data->test_form_KKT_A->i[2] = 2;
data->test_form_KKT_A->i[3] = 3;
data->test_form_KKT_A->i[4] = 4;
data->test_form_KKT_A->i[5] = 5;
data->test_form_KKT_A->i[6] = 6;
data->test_form_KKT_A->i[7] = 1;
data->test_form_KKT_A->i[8] = 2;
data->test_form_KKT_A->i[9] = 4;
data->test_form_KKT_A->i[10] = 5;
data->test_form_KKT_A->i[11] = 6;
data->test_form_KKT_A->i[12] = 0;
data->test_form_KKT_A->i[13] = 1;
data->test_form_KKT_A->i[14] = 3;
data->test_form_KKT_A->i[15] = 7;
data->test_form_KKT_A->i[16] = 0;
data->test_form_KKT_A->i[17] = 1;
data->test_form_KKT_A->i[18] = 3;
data->test_form_KKT_A->i[19] = 4;
data->test_form_KKT_A->i[20] = 5;
data->test_form_KKT_A->i[21] = 6;
data->test_form_KKT_A->i[22] = 0;
data->test_form_KKT_A->i[23] = 1;
data->test_form_KKT_A->i[24] = 2;
data->test_form_KKT_A->i[25] = 4;
data->test_form_KKT_A->i[26] = 5;
data->test_form_KKT_A->i[27] = 6;
data->test_form_KKT_A->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_form_KKT_A->p[0] = 0;
data->test_form_KKT_A->p[1] = 7;
data->test_form_KKT_A->p[2] = 12;
data->test_form_KKT_A->p[3] = 16;
data->test_form_KKT_A->p[4] = 22;
data->test_form_KKT_A->p[5] = 28;


// Matrix test_form_KKT_Pu
//------------------------
data->test_form_KKT_Pu = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_Pu->m = 5;
data->test_form_KKT_Pu->n = 5;
data->test_form_KKT_Pu->nz = -1;
data->test_form_KKT_Pu->nzmax = 14;
data->test_form_KKT_Pu->x = (c_float*) c_malloc(14 * sizeof(c_float));
data->test_form_KKT_Pu->x[0] = 2.71746448259240036549;
data->test_form_KKT_Pu->x[1] = 0.49090701555485460883;
data->test_form_KKT_Pu->x[2] = 1.24847963823228691460;
data->test_form_KKT_Pu->x[3] = 0.27027726771330962130;
data->test_form_KKT_Pu->x[4] = 1.22290695826329987028;
data->test_form_KKT_Pu->x[5] = 1.21989829749217926214;
data->test_form_KKT_Pu->x[6] = 0.26919184391888167918;
data->test_form_KKT_Pu->x[7] = 0.30565836578345267904;
data->test_form_KKT_Pu->x[8] = 2.60524179873652039774;
data->test_form_KKT_Pu->x[9] = 0.89169482895676566159;
data->test_form_KKT_Pu->x[10] = 0.28119215930561647365;
data->test_form_KKT_Pu->x[11] = 0.26529760403043434192;
data->test_form_KKT_Pu->x[12] = 0.69646170115872330086;
data->test_form_KKT_Pu->x[13] = 1.64397449001682471881;
data->test_form_KKT_Pu->i = (c_int*) c_malloc(14 * sizeof(c_int));
data->test_form_KKT_Pu->i[0] = 0;
data->test_form_KKT_Pu->i[1] = 0;
data->test_form_KKT_Pu->i[2] = 1;
data->test_form_KKT_Pu->i[3] = 0;
data->test_form_KKT_Pu->i[4] = 2;
data->test_form_KKT_Pu->i[5] = 0;
data->test_form_KKT_Pu->i[6] = 1;
data->test_form_KKT_Pu->i[7] = 2;
data->test_form_KKT_Pu->i[8] = 3;
data->test_form_KKT_Pu->i[9] = 0;
data->test_form_KKT_Pu->i[10] = 1;
data->test_form_KKT_Pu->i[11] = 2;
data->test_form_KKT_Pu->i[12] = 3;
data->test_form_KKT_Pu->i[13] = 4;
data->test_form_KKT_Pu->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_form_KKT_Pu->p[0] = 0;
data->test_form_KKT_Pu->p[1] = 1;
data->test_form_KKT_Pu->p[2] = 3;
data->test_form_KKT_Pu->p[3] = 5;
data->test_form_KKT_Pu->p[4] = 9;
data->test_form_KKT_Pu->p[5] = 14;

data->test_form_KKT_rho = 1.60000000000000008882;
data->test_form_KKT_sigma = 0.10000000000000000555;

// Matrix test_form_KKT_KKT
//-------------------------
data->test_form_KKT_KKT = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_KKT->m = 13;
data->test_form_KKT_KKT->n = 13;
data->test_form_KKT_KKT->nz = -1;
data->test_form_KKT_KKT->nzmax = 87;
data->test_form_KKT_KKT->x = (c_float*) c_malloc(87 * sizeof(c_float));
data->test_form_KKT_KKT->x[0] = 2.81746448259240045431;
data->test_form_KKT_KKT->x[1] = 0.49090701555485460883;
data->test_form_KKT_KKT->x[2] = 0.27027726771330962130;
data->test_form_KKT_KKT->x[3] = 1.21989829749217926214;
data->test_form_KKT_KKT->x[4] = 0.89169482895676566159;
data->test_form_KKT_KKT->x[5] = 0.57730806879569795953;
data->test_form_KKT_KKT->x[6] = 0.50952587649232417011;
data->test_form_KKT_KKT->x[7] = 0.16782331070145573015;
data->test_form_KKT_KKT->x[8] = 0.79820038783705349328;
data->test_form_KKT_KKT->x[9] = 0.46784249347153428200;
data->test_form_KKT_KKT->x[10] = 0.94809042190270420569;
data->test_form_KKT_KKT->x[11] = 0.27417325939046011118;
data->test_form_KKT_KKT->x[12] = 0.49090701555485460883;
data->test_form_KKT_KKT->x[13] = 1.34847963823228700342;
data->test_form_KKT_KKT->x[14] = 0.26919184391888167918;
data->test_form_KKT_KKT->x[15] = 0.28119215930561647365;
data->test_form_KKT_KKT->x[16] = 0.22183516701270400429;
data->test_form_KKT_KKT->x[17] = 0.35367537868439535842;
data->test_form_KKT_KKT->x[18] = 0.14856478348934898381;
data->test_form_KKT_KKT->x[19] = 0.46867358416621918149;
data->test_form_KKT_KKT->x[20] = 0.76749117091526242174;
data->test_form_KKT_KKT->x[21] = 0.27027726771330962130;
data->test_form_KKT_KKT->x[22] = 1.32290695826329995910;
data->test_form_KKT_KKT->x[23] = 0.30565836578345267904;
data->test_form_KKT_KKT->x[24] = 0.26529760403043434192;
data->test_form_KKT_KKT->x[25] = 0.85228103372865227083;
data->test_form_KKT_KKT->x[26] = 0.79308974374262031226;
data->test_form_KKT_KKT->x[27] = 0.25873317142982743544;
data->test_form_KKT_KKT->x[28] = 0.99326629446159042658;
data->test_form_KKT_KKT->x[29] = 1.21989829749217926214;
data->test_form_KKT_KKT->x[30] = 0.26919184391888167918;
data->test_form_KKT_KKT->x[31] = 0.30565836578345267904;
data->test_form_KKT_KKT->x[32] = 2.70524179873652048656;
data->test_form_KKT_KKT->x[33] = 0.69646170115872330086;
data->test_form_KKT_KKT->x[34] = 0.11948479832931302447;
data->test_form_KKT_KKT->x[35] = 0.31529748117286060527;
data->test_form_KKT_KKT->x[36] = 0.56576512922355526314;
data->test_form_KKT_KKT->x[37] = 0.82288464047648379740;
data->test_form_KKT_KKT->x[38] = 0.99085199519994981987;
data->test_form_KKT_KKT->x[39] = 0.36747136862384688349;
data->test_form_KKT_KKT->x[40] = 0.89169482895676566159;
data->test_form_KKT_KKT->x[41] = 0.28119215930561647365;
data->test_form_KKT_KKT->x[42] = 0.26529760403043434192;
data->test_form_KKT_KKT->x[43] = 0.69646170115872330086;
data->test_form_KKT_KKT->x[44] = 1.74397449001682480763;
data->test_form_KKT_KKT->x[45] = 0.80917528597077170716;
data->test_form_KKT_KKT->x[46] = 0.21726992644012010913;
data->test_form_KKT_KKT->x[47] = 0.81413841308724066437;
data->test_form_KKT_KKT->x[48] = 0.65426618220709131801;
data->test_form_KKT_KKT->x[49] = 0.66306179305086021536;
data->test_form_KKT_KKT->x[50] = 0.61302969450978517241;
data->test_form_KKT_KKT->x[51] = 0.57730806879569795953;
data->test_form_KKT_KKT->x[52] = 0.85228103372865227083;
data->test_form_KKT_KKT->x[53] = 0.11948479832931302447;
data->test_form_KKT_KKT->x[54] = 0.80917528597077170716;
data->test_form_KKT_KKT->x[55] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[56] = 0.50952587649232417011;
data->test_form_KKT_KKT->x[57] = 0.22183516701270400429;
data->test_form_KKT_KKT->x[58] = 0.79308974374262031226;
data->test_form_KKT_KKT->x[59] = 0.31529748117286060527;
data->test_form_KKT_KKT->x[60] = 0.21726992644012010913;
data->test_form_KKT_KKT->x[61] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[62] = 0.16782331070145573015;
data->test_form_KKT_KKT->x[63] = 0.35367537868439535842;
data->test_form_KKT_KKT->x[64] = 0.81413841308724066437;
data->test_form_KKT_KKT->x[65] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[66] = 0.79820038783705349328;
data->test_form_KKT_KKT->x[67] = 0.25873317142982743544;
data->test_form_KKT_KKT->x[68] = 0.56576512922355526314;
data->test_form_KKT_KKT->x[69] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[70] = 0.46784249347153428200;
data->test_form_KKT_KKT->x[71] = 0.14856478348934898381;
data->test_form_KKT_KKT->x[72] = 0.82288464047648379740;
data->test_form_KKT_KKT->x[73] = 0.65426618220709131801;
data->test_form_KKT_KKT->x[74] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[75] = 0.94809042190270420569;
data->test_form_KKT_KKT->x[76] = 0.46867358416621918149;
data->test_form_KKT_KKT->x[77] = 0.99085199519994981987;
data->test_form_KKT_KKT->x[78] = 0.66306179305086021536;
data->test_form_KKT_KKT->x[79] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[80] = 0.27417325939046011118;
data->test_form_KKT_KKT->x[81] = 0.76749117091526242174;
data->test_form_KKT_KKT->x[82] = 0.36747136862384688349;
data->test_form_KKT_KKT->x[83] = 0.61302969450978517241;
data->test_form_KKT_KKT->x[84] = -0.62500000000000000000;
data->test_form_KKT_KKT->x[85] = 0.99326629446159042658;
data->test_form_KKT_KKT->x[86] = -0.62500000000000000000;
data->test_form_KKT_KKT->i = (c_int*) c_malloc(87 * sizeof(c_int));
data->test_form_KKT_KKT->i[0] = 0;
data->test_form_KKT_KKT->i[1] = 1;
data->test_form_KKT_KKT->i[2] = 2;
data->test_form_KKT_KKT->i[3] = 3;
data->test_form_KKT_KKT->i[4] = 4;
data->test_form_KKT_KKT->i[5] = 5;
data->test_form_KKT_KKT->i[6] = 6;
data->test_form_KKT_KKT->i[7] = 7;
data->test_form_KKT_KKT->i[8] = 8;
data->test_form_KKT_KKT->i[9] = 9;
data->test_form_KKT_KKT->i[10] = 10;
data->test_form_KKT_KKT->i[11] = 11;
data->test_form_KKT_KKT->i[12] = 0;
data->test_form_KKT_KKT->i[13] = 1;
data->test_form_KKT_KKT->i[14] = 3;
data->test_form_KKT_KKT->i[15] = 4;
data->test_form_KKT_KKT->i[16] = 6;
data->test_form_KKT_KKT->i[17] = 7;
data->test_form_KKT_KKT->i[18] = 9;
data->test_form_KKT_KKT->i[19] = 10;
data->test_form_KKT_KKT->i[20] = 11;
data->test_form_KKT_KKT->i[21] = 0;
data->test_form_KKT_KKT->i[22] = 2;
data->test_form_KKT_KKT->i[23] = 3;
data->test_form_KKT_KKT->i[24] = 4;
data->test_form_KKT_KKT->i[25] = 5;
data->test_form_KKT_KKT->i[26] = 6;
data->test_form_KKT_KKT->i[27] = 8;
data->test_form_KKT_KKT->i[28] = 12;
data->test_form_KKT_KKT->i[29] = 0;
data->test_form_KKT_KKT->i[30] = 1;
data->test_form_KKT_KKT->i[31] = 2;
data->test_form_KKT_KKT->i[32] = 3;
data->test_form_KKT_KKT->i[33] = 4;
data->test_form_KKT_KKT->i[34] = 5;
data->test_form_KKT_KKT->i[35] = 6;
data->test_form_KKT_KKT->i[36] = 8;
data->test_form_KKT_KKT->i[37] = 9;
data->test_form_KKT_KKT->i[38] = 10;
data->test_form_KKT_KKT->i[39] = 11;
data->test_form_KKT_KKT->i[40] = 0;
data->test_form_KKT_KKT->i[41] = 1;
data->test_form_KKT_KKT->i[42] = 2;
data->test_form_KKT_KKT->i[43] = 3;
data->test_form_KKT_KKT->i[44] = 4;
data->test_form_KKT_KKT->i[45] = 5;
data->test_form_KKT_KKT->i[46] = 6;
data->test_form_KKT_KKT->i[47] = 7;
data->test_form_KKT_KKT->i[48] = 9;
data->test_form_KKT_KKT->i[49] = 10;
data->test_form_KKT_KKT->i[50] = 11;
data->test_form_KKT_KKT->i[51] = 0;
data->test_form_KKT_KKT->i[52] = 2;
data->test_form_KKT_KKT->i[53] = 3;
data->test_form_KKT_KKT->i[54] = 4;
data->test_form_KKT_KKT->i[55] = 5;
data->test_form_KKT_KKT->i[56] = 0;
data->test_form_KKT_KKT->i[57] = 1;
data->test_form_KKT_KKT->i[58] = 2;
data->test_form_KKT_KKT->i[59] = 3;
data->test_form_KKT_KKT->i[60] = 4;
data->test_form_KKT_KKT->i[61] = 6;
data->test_form_KKT_KKT->i[62] = 0;
data->test_form_KKT_KKT->i[63] = 1;
data->test_form_KKT_KKT->i[64] = 4;
data->test_form_KKT_KKT->i[65] = 7;
data->test_form_KKT_KKT->i[66] = 0;
data->test_form_KKT_KKT->i[67] = 2;
data->test_form_KKT_KKT->i[68] = 3;
data->test_form_KKT_KKT->i[69] = 8;
data->test_form_KKT_KKT->i[70] = 0;
data->test_form_KKT_KKT->i[71] = 1;
data->test_form_KKT_KKT->i[72] = 3;
data->test_form_KKT_KKT->i[73] = 4;
data->test_form_KKT_KKT->i[74] = 9;
data->test_form_KKT_KKT->i[75] = 0;
data->test_form_KKT_KKT->i[76] = 1;
data->test_form_KKT_KKT->i[77] = 3;
data->test_form_KKT_KKT->i[78] = 4;
data->test_form_KKT_KKT->i[79] = 10;
data->test_form_KKT_KKT->i[80] = 0;
data->test_form_KKT_KKT->i[81] = 1;
data->test_form_KKT_KKT->i[82] = 3;
data->test_form_KKT_KKT->i[83] = 4;
data->test_form_KKT_KKT->i[84] = 11;
data->test_form_KKT_KKT->i[85] = 2;
data->test_form_KKT_KKT->i[86] = 12;
data->test_form_KKT_KKT->p = (c_int*) c_malloc((13 + 1) * sizeof(c_int));
data->test_form_KKT_KKT->p[0] = 0;
data->test_form_KKT_KKT->p[1] = 12;
data->test_form_KKT_KKT->p[2] = 21;
data->test_form_KKT_KKT->p[3] = 29;
data->test_form_KKT_KKT->p[4] = 40;
data->test_form_KKT_KKT->p[5] = 51;
data->test_form_KKT_KKT->p[6] = 56;
data->test_form_KKT_KKT->p[7] = 62;
data->test_form_KKT_KKT->p[8] = 66;
data->test_form_KKT_KKT->p[9] = 70;
data->test_form_KKT_KKT->p[10] = 75;
data->test_form_KKT_KKT->p[11] = 80;
data->test_form_KKT_KKT->p[12] = 85;
data->test_form_KKT_KKT->p[13] = 87;


// Matrix test_form_KKT_KKTu
//--------------------------
data->test_form_KKT_KKTu = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_KKTu->m = 13;
data->test_form_KKT_KKTu->n = 13;
data->test_form_KKT_KKTu->nz = -1;
data->test_form_KKT_KKTu->nzmax = 50;
data->test_form_KKT_KKTu->x = (c_float*) c_malloc(50 * sizeof(c_float));
data->test_form_KKT_KKTu->x[0] = 2.81746448259240045431;
data->test_form_KKT_KKTu->x[1] = 0.49090701555485460883;
data->test_form_KKT_KKTu->x[2] = 1.34847963823228700342;
data->test_form_KKT_KKTu->x[3] = 0.27027726771330962130;
data->test_form_KKT_KKTu->x[4] = 1.32290695826329995910;
data->test_form_KKT_KKTu->x[5] = 1.21989829749217926214;
data->test_form_KKT_KKTu->x[6] = 0.26919184391888167918;
data->test_form_KKT_KKTu->x[7] = 0.30565836578345267904;
data->test_form_KKT_KKTu->x[8] = 2.70524179873652048656;
data->test_form_KKT_KKTu->x[9] = 0.89169482895676566159;
data->test_form_KKT_KKTu->x[10] = 0.28119215930561647365;
data->test_form_KKT_KKTu->x[11] = 0.26529760403043434192;
data->test_form_KKT_KKTu->x[12] = 0.69646170115872330086;
data->test_form_KKT_KKTu->x[13] = 1.74397449001682480763;
data->test_form_KKT_KKTu->x[14] = 0.57730806879569795953;
data->test_form_KKT_KKTu->x[15] = 0.85228103372865227083;
data->test_form_KKT_KKTu->x[16] = 0.11948479832931302447;
data->test_form_KKT_KKTu->x[17] = 0.80917528597077170716;
data->test_form_KKT_KKTu->x[18] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[19] = 0.50952587649232417011;
data->test_form_KKT_KKTu->x[20] = 0.22183516701270400429;
data->test_form_KKT_KKTu->x[21] = 0.79308974374262031226;
data->test_form_KKT_KKTu->x[22] = 0.31529748117286060527;
data->test_form_KKT_KKTu->x[23] = 0.21726992644012010913;
data->test_form_KKT_KKTu->x[24] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[25] = 0.16782331070145573015;
data->test_form_KKT_KKTu->x[26] = 0.35367537868439535842;
data->test_form_KKT_KKTu->x[27] = 0.81413841308724066437;
data->test_form_KKT_KKTu->x[28] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[29] = 0.79820038783705349328;
data->test_form_KKT_KKTu->x[30] = 0.25873317142982743544;
data->test_form_KKT_KKTu->x[31] = 0.56576512922355526314;
data->test_form_KKT_KKTu->x[32] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[33] = 0.46784249347153428200;
data->test_form_KKT_KKTu->x[34] = 0.14856478348934898381;
data->test_form_KKT_KKTu->x[35] = 0.82288464047648379740;
data->test_form_KKT_KKTu->x[36] = 0.65426618220709131801;
data->test_form_KKT_KKTu->x[37] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[38] = 0.94809042190270420569;
data->test_form_KKT_KKTu->x[39] = 0.46867358416621918149;
data->test_form_KKT_KKTu->x[40] = 0.99085199519994981987;
data->test_form_KKT_KKTu->x[41] = 0.66306179305086021536;
data->test_form_KKT_KKTu->x[42] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[43] = 0.27417325939046011118;
data->test_form_KKT_KKTu->x[44] = 0.76749117091526242174;
data->test_form_KKT_KKTu->x[45] = 0.36747136862384688349;
data->test_form_KKT_KKTu->x[46] = 0.61302969450978517241;
data->test_form_KKT_KKTu->x[47] = -0.62500000000000000000;
data->test_form_KKT_KKTu->x[48] = 0.99326629446159042658;
data->test_form_KKT_KKTu->x[49] = -0.62500000000000000000;
data->test_form_KKT_KKTu->i = (c_int*) c_malloc(50 * sizeof(c_int));
data->test_form_KKT_KKTu->i[0] = 0;
data->test_form_KKT_KKTu->i[1] = 0;
data->test_form_KKT_KKTu->i[2] = 1;
data->test_form_KKT_KKTu->i[3] = 0;
data->test_form_KKT_KKTu->i[4] = 2;
data->test_form_KKT_KKTu->i[5] = 0;
data->test_form_KKT_KKTu->i[6] = 1;
data->test_form_KKT_KKTu->i[7] = 2;
data->test_form_KKT_KKTu->i[8] = 3;
data->test_form_KKT_KKTu->i[9] = 0;
data->test_form_KKT_KKTu->i[10] = 1;
data->test_form_KKT_KKTu->i[11] = 2;
data->test_form_KKT_KKTu->i[12] = 3;
data->test_form_KKT_KKTu->i[13] = 4;
data->test_form_KKT_KKTu->i[14] = 0;
data->test_form_KKT_KKTu->i[15] = 2;
data->test_form_KKT_KKTu->i[16] = 3;
data->test_form_KKT_KKTu->i[17] = 4;
data->test_form_KKT_KKTu->i[18] = 5;
data->test_form_KKT_KKTu->i[19] = 0;
data->test_form_KKT_KKTu->i[20] = 1;
data->test_form_KKT_KKTu->i[21] = 2;
data->test_form_KKT_KKTu->i[22] = 3;
data->test_form_KKT_KKTu->i[23] = 4;
data->test_form_KKT_KKTu->i[24] = 6;
data->test_form_KKT_KKTu->i[25] = 0;
data->test_form_KKT_KKTu->i[26] = 1;
data->test_form_KKT_KKTu->i[27] = 4;
data->test_form_KKT_KKTu->i[28] = 7;
data->test_form_KKT_KKTu->i[29] = 0;
data->test_form_KKT_KKTu->i[30] = 2;
data->test_form_KKT_KKTu->i[31] = 3;
data->test_form_KKT_KKTu->i[32] = 8;
data->test_form_KKT_KKTu->i[33] = 0;
data->test_form_KKT_KKTu->i[34] = 1;
data->test_form_KKT_KKTu->i[35] = 3;
data->test_form_KKT_KKTu->i[36] = 4;
data->test_form_KKT_KKTu->i[37] = 9;
data->test_form_KKT_KKTu->i[38] = 0;
data->test_form_KKT_KKTu->i[39] = 1;
data->test_form_KKT_KKTu->i[40] = 3;
data->test_form_KKT_KKTu->i[41] = 4;
data->test_form_KKT_KKTu->i[42] = 10;
data->test_form_KKT_KKTu->i[43] = 0;
data->test_form_KKT_KKTu->i[44] = 1;
data->test_form_KKT_KKTu->i[45] = 3;
data->test_form_KKT_KKTu->i[46] = 4;
data->test_form_KKT_KKTu->i[47] = 11;
data->test_form_KKT_KKTu->i[48] = 2;
data->test_form_KKT_KKTu->i[49] = 12;
data->test_form_KKT_KKTu->p = (c_int*) c_malloc((13 + 1) * sizeof(c_int));
data->test_form_KKT_KKTu->p[0] = 0;
data->test_form_KKT_KKTu->p[1] = 1;
data->test_form_KKT_KKTu->p[2] = 3;
data->test_form_KKT_KKTu->p[3] = 5;
data->test_form_KKT_KKTu->p[4] = 9;
data->test_form_KKT_KKTu->p[5] = 14;
data->test_form_KKT_KKTu->p[6] = 19;
data->test_form_KKT_KKTu->p[7] = 25;
data->test_form_KKT_KKTu->p[8] = 29;
data->test_form_KKT_KKTu->p[9] = 33;
data->test_form_KKT_KKTu->p[10] = 38;
data->test_form_KKT_KKTu->p[11] = 43;
data->test_form_KKT_KKTu->p[12] = 48;
data->test_form_KKT_KKTu->p[13] = 50;


// Matrix test_form_KKT_A_new
//---------------------------
data->test_form_KKT_A_new = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_A_new->m = 8;
data->test_form_KKT_A_new->n = 5;
data->test_form_KKT_A_new->nz = -1;
data->test_form_KKT_A_new->nzmax = 28;
data->test_form_KKT_A_new->x = (c_float*) c_malloc(28 * sizeof(c_float));
data->test_form_KKT_A_new->x[0] = 0.38783880408331716794;
data->test_form_KKT_A_new->x[1] = 0.43230721113936698696;
data->test_form_KKT_A_new->x[2] = 0.99252631613843733671;
data->test_form_KKT_A_new->x[3] = 2.04641330843408741913;
data->test_form_KKT_A_new->x[4] = 0.06395022413359480185;
data->test_form_KKT_A_new->x[5] = -0.43642824463316065575;
data->test_form_KKT_A_new->x[6] = 1.64140868331758449372;
data->test_form_KKT_A_new->x[7] = 1.43972080006899449955;
data->test_form_KKT_A_new->x[8] = -0.10832996946898509893;
data->test_form_KKT_A_new->x[9] = 0.49945327757709528926;
data->test_form_KKT_A_new->x[10] = 0.85053981829291613881;
data->test_form_KKT_A_new->x[11] = 1.33376661235771853953;
data->test_form_KKT_A_new->x[12] = 1.05648901264276418033;
data->test_form_KKT_A_new->x[13] = 2.19978598540399072903;
data->test_form_KKT_A_new->x[14] = -1.47922633295474037496;
data->test_form_KKT_A_new->x[15] = 2.03409024785231906662;
data->test_form_KKT_A_new->x[16] = 0.49995676854431347902;
data->test_form_KKT_A_new->x[17] = 0.09816221242798123248;
data->test_form_KKT_A_new->x[18] = 1.73929662771850868097;
data->test_form_KKT_A_new->x[19] = -1.52071855052347815196;
data->test_form_KKT_A_new->x[20] = 2.15237348594072264163;
data->test_form_KKT_A_new->x[21] = 0.75354941622744142649;
data->test_form_KKT_A_new->x[22] = -0.32395798770621087037;
data->test_form_KKT_A_new->x[23] = 0.65036248109681105145;
data->test_form_KKT_A_new->x[24] = 0.51005197428592508047;
data->test_form_KKT_A_new->x[25] = 3.23956105027164076304;
data->test_form_KKT_A_new->x[26] = 2.49839451591568506572;
data->test_form_KKT_A_new->x[27] = 1.05371956692489465723;
data->test_form_KKT_A_new->i = (c_int*) c_malloc(28 * sizeof(c_int));
data->test_form_KKT_A_new->i[0] = 0;
data->test_form_KKT_A_new->i[1] = 1;
data->test_form_KKT_A_new->i[2] = 2;
data->test_form_KKT_A_new->i[3] = 3;
data->test_form_KKT_A_new->i[4] = 4;
data->test_form_KKT_A_new->i[5] = 5;
data->test_form_KKT_A_new->i[6] = 6;
data->test_form_KKT_A_new->i[7] = 1;
data->test_form_KKT_A_new->i[8] = 2;
data->test_form_KKT_A_new->i[9] = 4;
data->test_form_KKT_A_new->i[10] = 5;
data->test_form_KKT_A_new->i[11] = 6;
data->test_form_KKT_A_new->i[12] = 0;
data->test_form_KKT_A_new->i[13] = 1;
data->test_form_KKT_A_new->i[14] = 3;
data->test_form_KKT_A_new->i[15] = 7;
data->test_form_KKT_A_new->i[16] = 0;
data->test_form_KKT_A_new->i[17] = 1;
data->test_form_KKT_A_new->i[18] = 3;
data->test_form_KKT_A_new->i[19] = 4;
data->test_form_KKT_A_new->i[20] = 5;
data->test_form_KKT_A_new->i[21] = 6;
data->test_form_KKT_A_new->i[22] = 0;
data->test_form_KKT_A_new->i[23] = 1;
data->test_form_KKT_A_new->i[24] = 2;
data->test_form_KKT_A_new->i[25] = 4;
data->test_form_KKT_A_new->i[26] = 5;
data->test_form_KKT_A_new->i[27] = 6;
data->test_form_KKT_A_new->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_form_KKT_A_new->p[0] = 0;
data->test_form_KKT_A_new->p[1] = 7;
data->test_form_KKT_A_new->p[2] = 12;
data->test_form_KKT_A_new->p[3] = 16;
data->test_form_KKT_A_new->p[4] = 22;
data->test_form_KKT_A_new->p[5] = 28;


// Matrix test_form_KKT_Pu_new
//----------------------------
data->test_form_KKT_Pu_new = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_Pu_new->m = 5;
data->test_form_KKT_Pu_new->n = 5;
data->test_form_KKT_Pu_new->nz = -1;
data->test_form_KKT_Pu_new->nzmax = 14;
data->test_form_KKT_Pu_new->x = (c_float*) c_malloc(14 * sizeof(c_float));
data->test_form_KKT_Pu_new->x[0] = 2.64553909844973267340;
data->test_form_KKT_Pu_new->x[1] = 0.43256555609695385156;
data->test_form_KKT_Pu_new->x[2] = 1.21597467539410830639;
data->test_form_KKT_Pu_new->x[3] = 0.21425381708952992432;
data->test_form_KKT_Pu_new->x[4] = 1.13268235145624962534;
data->test_form_KKT_Pu_new->x[5] = 1.16080106994523468700;
data->test_form_KKT_Pu_new->x[6] = 0.24157389469380791125;
data->test_form_KKT_Pu_new->x[7] = 0.25396997641019397607;
data->test_form_KKT_Pu_new->x[8] = 2.53538280374288138574;
data->test_form_KKT_Pu_new->x[9] = 0.79880563650438374257;
data->test_form_KKT_Pu_new->x[10] = 0.53623598289358254121;
data->test_form_KKT_Pu_new->x[11] = 0.11798027925044576869;
data->test_form_KKT_Pu_new->x[12] = 0.59432022810651663480;
data->test_form_KKT_Pu_new->x[13] = 1.68721406011478536335;
data->test_form_KKT_Pu_new->i = (c_int*) c_malloc(14 * sizeof(c_int));
data->test_form_KKT_Pu_new->i[0] = 0;
data->test_form_KKT_Pu_new->i[1] = 0;
data->test_form_KKT_Pu_new->i[2] = 1;
data->test_form_KKT_Pu_new->i[3] = 0;
data->test_form_KKT_Pu_new->i[4] = 2;
data->test_form_KKT_Pu_new->i[5] = 0;
data->test_form_KKT_Pu_new->i[6] = 1;
data->test_form_KKT_Pu_new->i[7] = 2;
data->test_form_KKT_Pu_new->i[8] = 3;
data->test_form_KKT_Pu_new->i[9] = 0;
data->test_form_KKT_Pu_new->i[10] = 1;
data->test_form_KKT_Pu_new->i[11] = 2;
data->test_form_KKT_Pu_new->i[12] = 3;
data->test_form_KKT_Pu_new->i[13] = 4;
data->test_form_KKT_Pu_new->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_form_KKT_Pu_new->p[0] = 0;
data->test_form_KKT_Pu_new->p[1] = 1;
data->test_form_KKT_Pu_new->p[2] = 3;
data->test_form_KKT_Pu_new->p[3] = 5;
data->test_form_KKT_Pu_new->p[4] = 9;
data->test_form_KKT_Pu_new->p[5] = 14;


// Matrix test_form_KKT_KKT_new
//-----------------------------
data->test_form_KKT_KKT_new = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_KKT_new->m = 13;
data->test_form_KKT_KKT_new->n = 13;
data->test_form_KKT_KKT_new->nz = -1;
data->test_form_KKT_KKT_new->nzmax = 87;
data->test_form_KKT_KKT_new->x = (c_float*) c_malloc(87 * sizeof(c_float));
data->test_form_KKT_KKT_new->x[0] = 2.74553909844973276222;
data->test_form_KKT_KKT_new->x[1] = 0.43256555609695385156;
data->test_form_KKT_KKT_new->x[2] = 0.21425381708952992432;
data->test_form_KKT_KKT_new->x[3] = 1.16080106994523468700;
data->test_form_KKT_KKT_new->x[4] = 0.79880563650438374257;
data->test_form_KKT_KKT_new->x[5] = 0.38783880408331716794;
data->test_form_KKT_KKT_new->x[6] = 0.43230721113936698696;
data->test_form_KKT_KKT_new->x[7] = 0.99252631613843733671;
data->test_form_KKT_KKT_new->x[8] = 2.04641330843408741913;
data->test_form_KKT_KKT_new->x[9] = 0.06395022413359480185;
data->test_form_KKT_KKT_new->x[10] = -0.43642824463316065575;
data->test_form_KKT_KKT_new->x[11] = 1.64140868331758449372;
data->test_form_KKT_KKT_new->x[12] = 0.43256555609695385156;
data->test_form_KKT_KKT_new->x[13] = 1.31597467539410839521;
data->test_form_KKT_KKT_new->x[14] = 0.24157389469380791125;
data->test_form_KKT_KKT_new->x[15] = 0.53623598289358254121;
data->test_form_KKT_KKT_new->x[16] = 1.43972080006899449955;
data->test_form_KKT_KKT_new->x[17] = -0.10832996946898509893;
data->test_form_KKT_KKT_new->x[18] = 0.49945327757709528926;
data->test_form_KKT_KKT_new->x[19] = 0.85053981829291613881;
data->test_form_KKT_KKT_new->x[20] = 1.33376661235771853953;
data->test_form_KKT_KKT_new->x[21] = 0.21425381708952992432;
data->test_form_KKT_KKT_new->x[22] = 1.23268235145624971416;
data->test_form_KKT_KKT_new->x[23] = 0.25396997641019397607;
data->test_form_KKT_KKT_new->x[24] = 0.11798027925044576869;
data->test_form_KKT_KKT_new->x[25] = 1.05648901264276418033;
data->test_form_KKT_KKT_new->x[26] = 2.19978598540399072903;
data->test_form_KKT_KKT_new->x[27] = -1.47922633295474037496;
data->test_form_KKT_KKT_new->x[28] = 2.03409024785231906662;
data->test_form_KKT_KKT_new->x[29] = 1.16080106994523468700;
data->test_form_KKT_KKT_new->x[30] = 0.24157389469380791125;
data->test_form_KKT_KKT_new->x[31] = 0.25396997641019397607;
data->test_form_KKT_KKT_new->x[32] = 2.63538280374288147456;
data->test_form_KKT_KKT_new->x[33] = 0.59432022810651663480;
data->test_form_KKT_KKT_new->x[34] = 0.49995676854431347902;
data->test_form_KKT_KKT_new->x[35] = 0.09816221242798123248;
data->test_form_KKT_KKT_new->x[36] = 1.73929662771850868097;
data->test_form_KKT_KKT_new->x[37] = -1.52071855052347815196;
data->test_form_KKT_KKT_new->x[38] = 2.15237348594072264163;
data->test_form_KKT_KKT_new->x[39] = 0.75354941622744142649;
data->test_form_KKT_KKT_new->x[40] = 0.79880563650438374257;
data->test_form_KKT_KKT_new->x[41] = 0.53623598289358254121;
data->test_form_KKT_KKT_new->x[42] = 0.11798027925044576869;
data->test_form_KKT_KKT_new->x[43] = 0.59432022810651663480;
data->test_form_KKT_KKT_new->x[44] = 1.78721406011478545217;
data->test_form_KKT_KKT_new->x[45] = -0.32395798770621087037;
data->test_form_KKT_KKT_new->x[46] = 0.65036248109681105145;
data->test_form_KKT_KKT_new->x[47] = 0.51005197428592508047;
data->test_form_KKT_KKT_new->x[48] = 3.23956105027164076304;
data->test_form_KKT_KKT_new->x[49] = 2.49839451591568506572;
data->test_form_KKT_KKT_new->x[50] = 1.05371956692489465723;
data->test_form_KKT_KKT_new->x[51] = 0.38783880408331716794;
data->test_form_KKT_KKT_new->x[52] = 1.05648901264276418033;
data->test_form_KKT_KKT_new->x[53] = 0.49995676854431347902;
data->test_form_KKT_KKT_new->x[54] = -0.32395798770621087037;
data->test_form_KKT_KKT_new->x[55] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[56] = 0.43230721113936698696;
data->test_form_KKT_KKT_new->x[57] = 1.43972080006899449955;
data->test_form_KKT_KKT_new->x[58] = 2.19978598540399072903;
data->test_form_KKT_KKT_new->x[59] = 0.09816221242798123248;
data->test_form_KKT_KKT_new->x[60] = 0.65036248109681105145;
data->test_form_KKT_KKT_new->x[61] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[62] = 0.99252631613843733671;
data->test_form_KKT_KKT_new->x[63] = -0.10832996946898509893;
data->test_form_KKT_KKT_new->x[64] = 0.51005197428592508047;
data->test_form_KKT_KKT_new->x[65] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[66] = 2.04641330843408741913;
data->test_form_KKT_KKT_new->x[67] = -1.47922633295474037496;
data->test_form_KKT_KKT_new->x[68] = 1.73929662771850868097;
data->test_form_KKT_KKT_new->x[69] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[70] = 0.06395022413359480185;
data->test_form_KKT_KKT_new->x[71] = 0.49945327757709528926;
data->test_form_KKT_KKT_new->x[72] = -1.52071855052347815196;
data->test_form_KKT_KKT_new->x[73] = 3.23956105027164076304;
data->test_form_KKT_KKT_new->x[74] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[75] = -0.43642824463316065575;
data->test_form_KKT_KKT_new->x[76] = 0.85053981829291613881;
data->test_form_KKT_KKT_new->x[77] = 2.15237348594072264163;
data->test_form_KKT_KKT_new->x[78] = 2.49839451591568506572;
data->test_form_KKT_KKT_new->x[79] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[80] = 1.64140868331758449372;
data->test_form_KKT_KKT_new->x[81] = 1.33376661235771853953;
data->test_form_KKT_KKT_new->x[82] = 0.75354941622744142649;
data->test_form_KKT_KKT_new->x[83] = 1.05371956692489465723;
data->test_form_KKT_KKT_new->x[84] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->x[85] = 2.03409024785231906662;
data->test_form_KKT_KKT_new->x[86] = -0.62500000000000000000;
data->test_form_KKT_KKT_new->i = (c_int*) c_malloc(87 * sizeof(c_int));
data->test_form_KKT_KKT_new->i[0] = 0;
data->test_form_KKT_KKT_new->i[1] = 1;
data->test_form_KKT_KKT_new->i[2] = 2;
data->test_form_KKT_KKT_new->i[3] = 3;
data->test_form_KKT_KKT_new->i[4] = 4;
data->test_form_KKT_KKT_new->i[5] = 5;
data->test_form_KKT_KKT_new->i[6] = 6;
data->test_form_KKT_KKT_new->i[7] = 7;
data->test_form_KKT_KKT_new->i[8] = 8;
data->test_form_KKT_KKT_new->i[9] = 9;
data->test_form_KKT_KKT_new->i[10] = 10;
data->test_form_KKT_KKT_new->i[11] = 11;
data->test_form_KKT_KKT_new->i[12] = 0;
data->test_form_KKT_KKT_new->i[13] = 1;
data->test_form_KKT_KKT_new->i[14] = 3;
data->test_form_KKT_KKT_new->i[15] = 4;
data->test_form_KKT_KKT_new->i[16] = 6;
data->test_form_KKT_KKT_new->i[17] = 7;
data->test_form_KKT_KKT_new->i[18] = 9;
data->test_form_KKT_KKT_new->i[19] = 10;
data->test_form_KKT_KKT_new->i[20] = 11;
data->test_form_KKT_KKT_new->i[21] = 0;
data->test_form_KKT_KKT_new->i[22] = 2;
data->test_form_KKT_KKT_new->i[23] = 3;
data->test_form_KKT_KKT_new->i[24] = 4;
data->test_form_KKT_KKT_new->i[25] = 5;
data->test_form_KKT_KKT_new->i[26] = 6;
data->test_form_KKT_KKT_new->i[27] = 8;
data->test_form_KKT_KKT_new->i[28] = 12;
data->test_form_KKT_KKT_new->i[29] = 0;
data->test_form_KKT_KKT_new->i[30] = 1;
data->test_form_KKT_KKT_new->i[31] = 2;
data->test_form_KKT_KKT_new->i[32] = 3;
data->test_form_KKT_KKT_new->i[33] = 4;
data->test_form_KKT_KKT_new->i[34] = 5;
data->test_form_KKT_KKT_new->i[35] = 6;
data->test_form_KKT_KKT_new->i[36] = 8;
data->test_form_KKT_KKT_new->i[37] = 9;
data->test_form_KKT_KKT_new->i[38] = 10;
data->test_form_KKT_KKT_new->i[39] = 11;
data->test_form_KKT_KKT_new->i[40] = 0;
data->test_form_KKT_KKT_new->i[41] = 1;
data->test_form_KKT_KKT_new->i[42] = 2;
data->test_form_KKT_KKT_new->i[43] = 3;
data->test_form_KKT_KKT_new->i[44] = 4;
data->test_form_KKT_KKT_new->i[45] = 5;
data->test_form_KKT_KKT_new->i[46] = 6;
data->test_form_KKT_KKT_new->i[47] = 7;
data->test_form_KKT_KKT_new->i[48] = 9;
data->test_form_KKT_KKT_new->i[49] = 10;
data->test_form_KKT_KKT_new->i[50] = 11;
data->test_form_KKT_KKT_new->i[51] = 0;
data->test_form_KKT_KKT_new->i[52] = 2;
data->test_form_KKT_KKT_new->i[53] = 3;
data->test_form_KKT_KKT_new->i[54] = 4;
data->test_form_KKT_KKT_new->i[55] = 5;
data->test_form_KKT_KKT_new->i[56] = 0;
data->test_form_KKT_KKT_new->i[57] = 1;
data->test_form_KKT_KKT_new->i[58] = 2;
data->test_form_KKT_KKT_new->i[59] = 3;
data->test_form_KKT_KKT_new->i[60] = 4;
data->test_form_KKT_KKT_new->i[61] = 6;
data->test_form_KKT_KKT_new->i[62] = 0;
data->test_form_KKT_KKT_new->i[63] = 1;
data->test_form_KKT_KKT_new->i[64] = 4;
data->test_form_KKT_KKT_new->i[65] = 7;
data->test_form_KKT_KKT_new->i[66] = 0;
data->test_form_KKT_KKT_new->i[67] = 2;
data->test_form_KKT_KKT_new->i[68] = 3;
data->test_form_KKT_KKT_new->i[69] = 8;
data->test_form_KKT_KKT_new->i[70] = 0;
data->test_form_KKT_KKT_new->i[71] = 1;
data->test_form_KKT_KKT_new->i[72] = 3;
data->test_form_KKT_KKT_new->i[73] = 4;
data->test_form_KKT_KKT_new->i[74] = 9;
data->test_form_KKT_KKT_new->i[75] = 0;
data->test_form_KKT_KKT_new->i[76] = 1;
data->test_form_KKT_KKT_new->i[77] = 3;
data->test_form_KKT_KKT_new->i[78] = 4;
data->test_form_KKT_KKT_new->i[79] = 10;
data->test_form_KKT_KKT_new->i[80] = 0;
data->test_form_KKT_KKT_new->i[81] = 1;
data->test_form_KKT_KKT_new->i[82] = 3;
data->test_form_KKT_KKT_new->i[83] = 4;
data->test_form_KKT_KKT_new->i[84] = 11;
data->test_form_KKT_KKT_new->i[85] = 2;
data->test_form_KKT_KKT_new->i[86] = 12;
data->test_form_KKT_KKT_new->p = (c_int*) c_malloc((13 + 1) * sizeof(c_int));
data->test_form_KKT_KKT_new->p[0] = 0;
data->test_form_KKT_KKT_new->p[1] = 12;
data->test_form_KKT_KKT_new->p[2] = 21;
data->test_form_KKT_KKT_new->p[3] = 29;
data->test_form_KKT_KKT_new->p[4] = 40;
data->test_form_KKT_KKT_new->p[5] = 51;
data->test_form_KKT_KKT_new->p[6] = 56;
data->test_form_KKT_KKT_new->p[7] = 62;
data->test_form_KKT_KKT_new->p[8] = 66;
data->test_form_KKT_KKT_new->p[9] = 70;
data->test_form_KKT_KKT_new->p[10] = 75;
data->test_form_KKT_KKT_new->p[11] = 80;
data->test_form_KKT_KKT_new->p[12] = 85;
data->test_form_KKT_KKT_new->p[13] = 87;


// Matrix test_form_KKT_KKTu_new
//------------------------------
data->test_form_KKT_KKTu_new = (csc*) c_malloc(sizeof(csc));
data->test_form_KKT_KKTu_new->m = 13;
data->test_form_KKT_KKTu_new->n = 13;
data->test_form_KKT_KKTu_new->nz = -1;
data->test_form_KKT_KKTu_new->nzmax = 50;
data->test_form_KKT_KKTu_new->x = (c_float*) c_malloc(50 * sizeof(c_float));
data->test_form_KKT_KKTu_new->x[0] = 2.74553909844973276222;
data->test_form_KKT_KKTu_new->x[1] = 0.43256555609695385156;
data->test_form_KKT_KKTu_new->x[2] = 1.31597467539410839521;
data->test_form_KKT_KKTu_new->x[3] = 0.21425381708952992432;
data->test_form_KKT_KKTu_new->x[4] = 1.23268235145624971416;
data->test_form_KKT_KKTu_new->x[5] = 1.16080106994523468700;
data->test_form_KKT_KKTu_new->x[6] = 0.24157389469380791125;
data->test_form_KKT_KKTu_new->x[7] = 0.25396997641019397607;
data->test_form_KKT_KKTu_new->x[8] = 2.63538280374288147456;
data->test_form_KKT_KKTu_new->x[9] = 0.79880563650438374257;
data->test_form_KKT_KKTu_new->x[10] = 0.53623598289358254121;
data->test_form_KKT_KKTu_new->x[11] = 0.11798027925044576869;
data->test_form_KKT_KKTu_new->x[12] = 0.59432022810651663480;
data->test_form_KKT_KKTu_new->x[13] = 1.78721406011478545217;
data->test_form_KKT_KKTu_new->x[14] = 0.38783880408331716794;
data->test_form_KKT_KKTu_new->x[15] = 1.05648901264276418033;
data->test_form_KKT_KKTu_new->x[16] = 0.49995676854431347902;
data->test_form_KKT_KKTu_new->x[17] = -0.32395798770621087037;
data->test_form_KKT_KKTu_new->x[18] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[19] = 0.43230721113936698696;
data->test_form_KKT_KKTu_new->x[20] = 1.43972080006899449955;
data->test_form_KKT_KKTu_new->x[21] = 2.19978598540399072903;
data->test_form_KKT_KKTu_new->x[22] = 0.09816221242798123248;
data->test_form_KKT_KKTu_new->x[23] = 0.65036248109681105145;
data->test_form_KKT_KKTu_new->x[24] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[25] = 0.99252631613843733671;
data->test_form_KKT_KKTu_new->x[26] = -0.10832996946898509893;
data->test_form_KKT_KKTu_new->x[27] = 0.51005197428592508047;
data->test_form_KKT_KKTu_new->x[28] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[29] = 2.04641330843408741913;
data->test_form_KKT_KKTu_new->x[30] = -1.47922633295474037496;
data->test_form_KKT_KKTu_new->x[31] = 1.73929662771850868097;
data->test_form_KKT_KKTu_new->x[32] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[33] = 0.06395022413359480185;
data->test_form_KKT_KKTu_new->x[34] = 0.49945327757709528926;
data->test_form_KKT_KKTu_new->x[35] = -1.52071855052347815196;
data->test_form_KKT_KKTu_new->x[36] = 3.23956105027164076304;
data->test_form_KKT_KKTu_new->x[37] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[38] = -0.43642824463316065575;
data->test_form_KKT_KKTu_new->x[39] = 0.85053981829291613881;
data->test_form_KKT_KKTu_new->x[40] = 2.15237348594072264163;
data->test_form_KKT_KKTu_new->x[41] = 2.49839451591568506572;
data->test_form_KKT_KKTu_new->x[42] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[43] = 1.64140868331758449372;
data->test_form_KKT_KKTu_new->x[44] = 1.33376661235771853953;
data->test_form_KKT_KKTu_new->x[45] = 0.75354941622744142649;
data->test_form_KKT_KKTu_new->x[46] = 1.05371956692489465723;
data->test_form_KKT_KKTu_new->x[47] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->x[48] = 2.03409024785231906662;
data->test_form_KKT_KKTu_new->x[49] = -0.62500000000000000000;
data->test_form_KKT_KKTu_new->i = (c_int*) c_malloc(50 * sizeof(c_int));
data->test_form_KKT_KKTu_new->i[0] = 0;
data->test_form_KKT_KKTu_new->i[1] = 0;
data->test_form_KKT_KKTu_new->i[2] = 1;
data->test_form_KKT_KKTu_new->i[3] = 0;
data->test_form_KKT_KKTu_new->i[4] = 2;
data->test_form_KKT_KKTu_new->i[5] = 0;
data->test_form_KKT_KKTu_new->i[6] = 1;
data->test_form_KKT_KKTu_new->i[7] = 2;
data->test_form_KKT_KKTu_new->i[8] = 3;
data->test_form_KKT_KKTu_new->i[9] = 0;
data->test_form_KKT_KKTu_new->i[10] = 1;
data->test_form_KKT_KKTu_new->i[11] = 2;
data->test_form_KKT_KKTu_new->i[12] = 3;
data->test_form_KKT_KKTu_new->i[13] = 4;
data->test_form_KKT_KKTu_new->i[14] = 0;
data->test_form_KKT_KKTu_new->i[15] = 2;
data->test_form_KKT_KKTu_new->i[16] = 3;
data->test_form_KKT_KKTu_new->i[17] = 4;
data->test_form_KKT_KKTu_new->i[18] = 5;
data->test_form_KKT_KKTu_new->i[19] = 0;
data->test_form_KKT_KKTu_new->i[20] = 1;
data->test_form_KKT_KKTu_new->i[21] = 2;
data->test_form_KKT_KKTu_new->i[22] = 3;
data->test_form_KKT_KKTu_new->i[23] = 4;
data->test_form_KKT_KKTu_new->i[24] = 6;
data->test_form_KKT_KKTu_new->i[25] = 0;
data->test_form_KKT_KKTu_new->i[26] = 1;
data->test_form_KKT_KKTu_new->i[27] = 4;
data->test_form_KKT_KKTu_new->i[28] = 7;
data->test_form_KKT_KKTu_new->i[29] = 0;
data->test_form_KKT_KKTu_new->i[30] = 2;
data->test_form_KKT_KKTu_new->i[31] = 3;
data->test_form_KKT_KKTu_new->i[32] = 8;
data->test_form_KKT_KKTu_new->i[33] = 0;
data->test_form_KKT_KKTu_new->i[34] = 1;
data->test_form_KKT_KKTu_new->i[35] = 3;
data->test_form_KKT_KKTu_new->i[36] = 4;
data->test_form_KKT_KKTu_new->i[37] = 9;
data->test_form_KKT_KKTu_new->i[38] = 0;
data->test_form_KKT_KKTu_new->i[39] = 1;
data->test_form_KKT_KKTu_new->i[40] = 3;
data->test_form_KKT_KKTu_new->i[41] = 4;
data->test_form_KKT_KKTu_new->i[42] = 10;
data->test_form_KKT_KKTu_new->i[43] = 0;
data->test_form_KKT_KKTu_new->i[44] = 1;
data->test_form_KKT_KKTu_new->i[45] = 3;
data->test_form_KKT_KKTu_new->i[46] = 4;
data->test_form_KKT_KKTu_new->i[47] = 11;
data->test_form_KKT_KKTu_new->i[48] = 2;
data->test_form_KKT_KKTu_new->i[49] = 12;
data->test_form_KKT_KKTu_new->p = (c_int*) c_malloc((13 + 1) * sizeof(c_int));
data->test_form_KKT_KKTu_new->p[0] = 0;
data->test_form_KKT_KKTu_new->p[1] = 1;
data->test_form_KKT_KKTu_new->p[2] = 3;
data->test_form_KKT_KKTu_new->p[3] = 5;
data->test_form_KKT_KKTu_new->p[4] = 9;
data->test_form_KKT_KKTu_new->p[5] = 14;
data->test_form_KKT_KKTu_new->p[6] = 19;
data->test_form_KKT_KKTu_new->p[7] = 25;
data->test_form_KKT_KKTu_new->p[8] = 29;
data->test_form_KKT_KKTu_new->p[9] = 33;
data->test_form_KKT_KKTu_new->p[10] = 38;
data->test_form_KKT_KKTu_new->p[11] = 43;
data->test_form_KKT_KKTu_new->p[12] = 48;
data->test_form_KKT_KKTu_new->p[13] = 50;


// Matrix test_solve_Pu
//---------------------
data->test_solve_Pu = (csc*) c_malloc(sizeof(csc));
data->test_solve_Pu->m = 5;
data->test_solve_Pu->n = 5;
data->test_solve_Pu->nz = -1;
data->test_solve_Pu->nzmax = 14;
data->test_solve_Pu->x = (c_float*) c_malloc(14 * sizeof(c_float));
data->test_solve_Pu->x[0] = 2.71746448259240036549;
data->test_solve_Pu->x[1] = 0.49090701555485460883;
data->test_solve_Pu->x[2] = 1.24847963823228691460;
data->test_solve_Pu->x[3] = 0.27027726771330962130;
data->test_solve_Pu->x[4] = 1.22290695826329987028;
data->test_solve_Pu->x[5] = 1.21989829749217926214;
data->test_solve_Pu->x[6] = 0.26919184391888167918;
data->test_solve_Pu->x[7] = 0.30565836578345267904;
data->test_solve_Pu->x[8] = 2.60524179873652039774;
data->test_solve_Pu->x[9] = 0.89169482895676566159;
data->test_solve_Pu->x[10] = 0.28119215930561647365;
data->test_solve_Pu->x[11] = 0.26529760403043434192;
data->test_solve_Pu->x[12] = 0.69646170115872330086;
data->test_solve_Pu->x[13] = 1.64397449001682471881;
data->test_solve_Pu->i = (c_int*) c_malloc(14 * sizeof(c_int));
data->test_solve_Pu->i[0] = 0;
data->test_solve_Pu->i[1] = 0;
data->test_solve_Pu->i[2] = 1;
data->test_solve_Pu->i[3] = 0;
data->test_solve_Pu->i[4] = 2;
data->test_solve_Pu->i[5] = 0;
data->test_solve_Pu->i[6] = 1;
data->test_solve_Pu->i[7] = 2;
data->test_solve_Pu->i[8] = 3;
data->test_solve_Pu->i[9] = 0;
data->test_solve_Pu->i[10] = 1;
data->test_solve_Pu->i[11] = 2;
data->test_solve_Pu->i[12] = 3;
data->test_solve_Pu->i[13] = 4;
data->test_solve_Pu->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_solve_Pu->p[0] = 0;
data->test_solve_Pu->p[1] = 1;
data->test_solve_Pu->p[2] = 3;
data->test_solve_Pu->p[3] = 5;
data->test_solve_Pu->p[4] = 9;
data->test_solve_Pu->p[5] = 14;

data->test_solve_q = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_solve_q[0] = -0.32358007007652395126;
data->test_solve_q[1] = 0.42382470786588066769;
data->test_solve_q[2] = 0.79917999503501535585;
data->test_solve_q[3] = 1.26261366332482016794;
data->test_solve_q[4] = 0.75196484921488060404;

// Matrix test_solve_A
//--------------------
data->test_solve_A = (csc*) c_malloc(sizeof(csc));
data->test_solve_A->m = 8;
data->test_solve_A->n = 5;
data->test_solve_A->nz = -1;
data->test_solve_A->nzmax = 28;
data->test_solve_A->x = (c_float*) c_malloc(28 * sizeof(c_float));
data->test_solve_A->x[0] = 0.57730806879569795953;
data->test_solve_A->x[1] = 0.50952587649232417011;
data->test_solve_A->x[2] = 0.16782331070145573015;
data->test_solve_A->x[3] = 0.79820038783705349328;
data->test_solve_A->x[4] = 0.46784249347153428200;
data->test_solve_A->x[5] = 0.94809042190270420569;
data->test_solve_A->x[6] = 0.27417325939046011118;
data->test_solve_A->x[7] = 0.22183516701270400429;
data->test_solve_A->x[8] = 0.35367537868439535842;
data->test_solve_A->x[9] = 0.14856478348934898381;
data->test_solve_A->x[10] = 0.46867358416621918149;
data->test_solve_A->x[11] = 0.76749117091526242174;
data->test_solve_A->x[12] = 0.85228103372865227083;
data->test_solve_A->x[13] = 0.79308974374262031226;
data->test_solve_A->x[14] = 0.25873317142982743544;
data->test_solve_A->x[15] = 0.99326629446159042658;
data->test_solve_A->x[16] = 0.11948479832931302447;
data->test_solve_A->x[17] = 0.31529748117286060527;
data->test_solve_A->x[18] = 0.56576512922355526314;
data->test_solve_A->x[19] = 0.82288464047648379740;
data->test_solve_A->x[20] = 0.99085199519994981987;
data->test_solve_A->x[21] = 0.36747136862384688349;
data->test_solve_A->x[22] = 0.80917528597077170716;
data->test_solve_A->x[23] = 0.21726992644012010913;
data->test_solve_A->x[24] = 0.81413841308724066437;
data->test_solve_A->x[25] = 0.65426618220709131801;
data->test_solve_A->x[26] = 0.66306179305086021536;
data->test_solve_A->x[27] = 0.61302969450978517241;
data->test_solve_A->i = (c_int*) c_malloc(28 * sizeof(c_int));
data->test_solve_A->i[0] = 0;
data->test_solve_A->i[1] = 1;
data->test_solve_A->i[2] = 2;
data->test_solve_A->i[3] = 3;
data->test_solve_A->i[4] = 4;
data->test_solve_A->i[5] = 5;
data->test_solve_A->i[6] = 6;
data->test_solve_A->i[7] = 1;
data->test_solve_A->i[8] = 2;
data->test_solve_A->i[9] = 4;
data->test_solve_A->i[10] = 5;
data->test_solve_A->i[11] = 6;
data->test_solve_A->i[12] = 0;
data->test_solve_A->i[13] = 1;
data->test_solve_A->i[14] = 3;
data->test_solve_A->i[15] = 7;
data->test_solve_A->i[16] = 0;
data->test_solve_A->i[17] = 1;
data->test_solve_A->i[18] = 3;
data->test_solve_A->i[19] = 4;
data->test_solve_A->i[20] = 5;
data->test_solve_A->i[21] = 6;
data->test_solve_A->i[22] = 0;
data->test_solve_A->i[23] = 1;
data->test_solve_A->i[24] = 2;
data->test_solve_A->i[25] = 4;
data->test_solve_A->i[26] = 5;
data->test_solve_A->i[27] = 6;
data->test_solve_A->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_solve_A->p[0] = 0;
data->test_solve_A->p[1] = 7;
data->test_solve_A->p[2] = 12;
data->test_solve_A->p[3] = 16;
data->test_solve_A->p[4] = 22;
data->test_solve_A->p[5] = 28;

data->test_solve_l = (c_float*) c_malloc(8 * sizeof(c_float));
data->test_solve_l[0] = -30.99376098311859095702;
data->test_solve_l[1] = -28.89085671863835358408;
data->test_solve_l[2] = -31.76491772827575488236;
data->test_solve_l[3] = -30.11442129703011971742;
data->test_solve_l[4] = -30.49817419392175921189;
data->test_solve_l[5] = -31.06079903633043315381;
data->test_solve_l[6] = -29.40833347927232210850;
data->test_solve_l[7] = -30.18325657377958037841;
data->test_solve_u = (c_float*) c_malloc(8 * sizeof(c_float));
data->test_solve_u[0] = 31.01985472936923571297;
data->test_solve_u[1] = 28.51753452217732842655;
data->test_solve_u[2] = 30.84631189184208110987;
data->test_solve_u[3] = 30.49794014836681910197;
data->test_solve_u[4] = 30.12650417530650770459;
data->test_solve_u[5] = 28.58118944885146461843;
data->test_solve_u[6] = 29.74822588163017655916;
data->test_solve_u[7] = 28.45332538873558547721;
data->n = 5;
data->m = 8;
data->test_solve_x = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_solve_x[0] = -0.34967513000000000067;
data->test_solve_x[1] = 1.20460721999999997855;
data->test_solve_x[2] = -0.46259804999999998287;
data->test_solve_x[3] = 0.59083905000000003227;
data->test_solve_x[4] = -0.87685541000000000178;
data->test_solve_y = (c_float*) c_malloc(8 * sizeof(c_float));
data->test_solve_y[0] = 0.00000000000000000000;
data->test_solve_y[1] = 0.00000000000000000000;
data->test_solve_y[2] = 0.00000000000000000000;
data->test_solve_y[3] = 0.00000000000000000000;
data->test_solve_y[4] = 0.00000000000000000000;
data->test_solve_y[5] = 0.00000000000000000000;
data->test_solve_y[6] = 0.00000000000000000000;
data->test_solve_y[7] = 0.00000000000000000000;
data->test_solve_obj_value = -1.76651270804831028727;
data->test_solve_status = OSQP_SOLVED;

// Matrix test_solve_Pu_new
//-------------------------
data->test_solve_Pu_new = (csc*) c_malloc(sizeof(csc));
data->test_solve_Pu_new->m = 5;
data->test_solve_Pu_new->n = 5;
data->test_solve_Pu_new->nz = -1;
data->test_solve_Pu_new->nzmax = 14;
data->test_solve_Pu_new->x = (c_float*) c_malloc(14 * sizeof(c_float));
data->test_solve_Pu_new->x[0] = 2.64553909844973267340;
data->test_solve_Pu_new->x[1] = 0.43256555609695385156;
data->test_solve_Pu_new->x[2] = 1.21597467539410830639;
data->test_solve_Pu_new->x[3] = 0.21425381708952992432;
data->test_solve_Pu_new->x[4] = 1.13268235145624962534;
data->test_solve_Pu_new->x[5] = 1.16080106994523468700;
data->test_solve_Pu_new->x[6] = 0.24157389469380791125;
data->test_solve_Pu_new->x[7] = 0.25396997641019397607;
data->test_solve_Pu_new->x[8] = 2.53538280374288138574;
data->test_solve_Pu_new->x[9] = 0.79880563650438374257;
data->test_solve_Pu_new->x[10] = 0.53623598289358254121;
data->test_solve_Pu_new->x[11] = 0.11798027925044576869;
data->test_solve_Pu_new->x[12] = 0.59432022810651663480;
data->test_solve_Pu_new->x[13] = 1.68721406011478536335;
data->test_solve_Pu_new->i = (c_int*) c_malloc(14 * sizeof(c_int));
data->test_solve_Pu_new->i[0] = 0;
data->test_solve_Pu_new->i[1] = 0;
data->test_solve_Pu_new->i[2] = 1;
data->test_solve_Pu_new->i[3] = 0;
data->test_solve_Pu_new->i[4] = 2;
data->test_solve_Pu_new->i[5] = 0;
data->test_solve_Pu_new->i[6] = 1;
data->test_solve_Pu_new->i[7] = 2;
data->test_solve_Pu_new->i[8] = 3;
data->test_solve_Pu_new->i[9] = 0;
data->test_solve_Pu_new->i[10] = 1;
data->test_solve_Pu_new->i[11] = 2;
data->test_solve_Pu_new->i[12] = 3;
data->test_solve_Pu_new->i[13] = 4;
data->test_solve_Pu_new->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_solve_Pu_new->p[0] = 0;
data->test_solve_Pu_new->p[1] = 1;
data->test_solve_Pu_new->p[2] = 3;
data->test_solve_Pu_new->p[3] = 5;
data->test_solve_Pu_new->p[4] = 9;
data->test_solve_Pu_new->p[5] = 14;

data->test_solve_P_new_x = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_solve_P_new_x[0] = -0.28228879000000001165;
data->test_solve_P_new_x[1] = 1.35277029999999998111;
data->test_solve_P_new_x[2] = -0.69277180999999998789;
data->test_solve_P_new_x[3] = 0.82445911000000005053;
data->test_solve_P_new_x[4] = -1.11688133999999994472;
data->test_solve_P_new_y = (c_float*) c_malloc(8 * sizeof(c_float));
data->test_solve_P_new_y[0] = 0.00000000000000000000;
data->test_solve_P_new_y[1] = 0.00000000000000000000;
data->test_solve_P_new_y[2] = 0.00000000000000000000;
data->test_solve_P_new_y[3] = 0.00000000000000000000;
data->test_solve_P_new_y[4] = 0.00000000000000000000;
data->test_solve_P_new_y[5] = 0.00000000000000000000;
data->test_solve_P_new_y[6] = 0.00000000000000000000;
data->test_solve_P_new_y[7] = 0.00000000000000000000;
data->test_solve_P_new_obj_value = -2.14908993117285262997;
data->test_solve_P_new_status = OSQP_SOLVED;

// Matrix test_solve_A_new
//------------------------
data->test_solve_A_new = (csc*) c_malloc(sizeof(csc));
data->test_solve_A_new->m = 8;
data->test_solve_A_new->n = 5;
data->test_solve_A_new->nz = -1;
data->test_solve_A_new->nzmax = 28;
data->test_solve_A_new->x = (c_float*) c_malloc(28 * sizeof(c_float));
data->test_solve_A_new->x[0] = 0.38783880408331716794;
data->test_solve_A_new->x[1] = 0.43230721113936698696;
data->test_solve_A_new->x[2] = 0.99252631613843733671;
data->test_solve_A_new->x[3] = 2.04641330843408741913;
data->test_solve_A_new->x[4] = 0.06395022413359480185;
data->test_solve_A_new->x[5] = -0.43642824463316065575;
data->test_solve_A_new->x[6] = 1.64140868331758449372;
data->test_solve_A_new->x[7] = 1.43972080006899449955;
data->test_solve_A_new->x[8] = -0.10832996946898509893;
data->test_solve_A_new->x[9] = 0.49945327757709528926;
data->test_solve_A_new->x[10] = 0.85053981829291613881;
data->test_solve_A_new->x[11] = 1.33376661235771853953;
data->test_solve_A_new->x[12] = 1.05648901264276418033;
data->test_solve_A_new->x[13] = 2.19978598540399072903;
data->test_solve_A_new->x[14] = -1.47922633295474037496;
data->test_solve_A_new->x[15] = 2.03409024785231906662;
data->test_solve_A_new->x[16] = 0.49995676854431347902;
data->test_solve_A_new->x[17] = 0.09816221242798123248;
data->test_solve_A_new->x[18] = 1.73929662771850868097;
data->test_solve_A_new->x[19] = -1.52071855052347815196;
data->test_solve_A_new->x[20] = 2.15237348594072264163;
data->test_solve_A_new->x[21] = 0.75354941622744142649;
data->test_solve_A_new->x[22] = -0.32395798770621087037;
data->test_solve_A_new->x[23] = 0.65036248109681105145;
data->test_solve_A_new->x[24] = 0.51005197428592508047;
data->test_solve_A_new->x[25] = 3.23956105027164076304;
data->test_solve_A_new->x[26] = 2.49839451591568506572;
data->test_solve_A_new->x[27] = 1.05371956692489465723;
data->test_solve_A_new->i = (c_int*) c_malloc(28 * sizeof(c_int));
data->test_solve_A_new->i[0] = 0;
data->test_solve_A_new->i[1] = 1;
data->test_solve_A_new->i[2] = 2;
data->test_solve_A_new->i[3] = 3;
data->test_solve_A_new->i[4] = 4;
data->test_solve_A_new->i[5] = 5;
data->test_solve_A_new->i[6] = 6;
data->test_solve_A_new->i[7] = 1;
data->test_solve_A_new->i[8] = 2;
data->test_solve_A_new->i[9] = 4;
data->test_solve_A_new->i[10] = 5;
data->test_solve_A_new->i[11] = 6;
data->test_solve_A_new->i[12] = 0;
data->test_solve_A_new->i[13] = 1;
data->test_solve_A_new->i[14] = 3;
data->test_solve_A_new->i[15] = 7;
data->test_solve_A_new->i[16] = 0;
data->test_solve_A_new->i[17] = 1;
data->test_solve_A_new->i[18] = 3;
data->test_solve_A_new->i[19] = 4;
data->test_solve_A_new->i[20] = 5;
data->test_solve_A_new->i[21] = 6;
data->test_solve_A_new->i[22] = 0;
data->test_solve_A_new->i[23] = 1;
data->test_solve_A_new->i[24] = 2;
data->test_solve_A_new->i[25] = 4;
data->test_solve_A_new->i[26] = 5;
data->test_solve_A_new->i[27] = 6;
data->test_solve_A_new->p = (c_int*) c_malloc((5 + 1) * sizeof(c_int));
data->test_solve_A_new->p[0] = 0;
data->test_solve_A_new->p[1] = 7;
data->test_solve_A_new->p[2] = 12;
data->test_solve_A_new->p[3] = 16;
data->test_solve_A_new->p[4] = 22;
data->test_solve_A_new->p[5] = 28;

data->test_solve_A_new_x = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_solve_A_new_x[0] = -0.34967513000000000067;
data->test_solve_A_new_x[1] = 1.20460721999999997855;
data->test_solve_A_new_x[2] = -0.46259804999999998287;
data->test_solve_A_new_x[3] = 0.59083905000000003227;
data->test_solve_A_new_x[4] = -0.87685541000000000178;
data->test_solve_A_new_y = (c_float*) c_malloc(8 * sizeof(c_float));
data->test_solve_A_new_y[0] = 0.00000000000000000000;
data->test_solve_A_new_y[1] = 0.00000000000000000000;
data->test_solve_A_new_y[2] = 0.00000000000000000000;
data->test_solve_A_new_y[3] = 0.00000000000000000000;
data->test_solve_A_new_y[4] = 0.00000000000000000000;
data->test_solve_A_new_y[5] = 0.00000000000000000000;
data->test_solve_A_new_y[6] = 0.00000000000000000000;
data->test_solve_A_new_y[7] = 0.00000000000000000000;
data->test_solve_A_new_obj_value = -1.76651270804848081752;
data->test_solve_A_new_status = OSQP_SOLVED;
data->test_solve_P_A_new_x = (c_float*) c_malloc(5 * sizeof(c_float));
data->test_solve_P_A_new_x[0] = -0.28228879000000001165;
data->test_solve_P_A_new_x[1] = 1.35277029999999998111;
data->test_solve_P_A_new_x[2] = -0.69277180999999998789;
data->test_solve_P_A_new_x[3] = 0.82445911000000005053;
data->test_solve_P_A_new_x[4] = -1.11688133999999994472;
data->test_solve_P_A_new_y = (c_float*) c_malloc(8 * sizeof(c_float));
data->test_solve_P_A_new_y[0] = 0.00000000000000000000;
data->test_solve_P_A_new_y[1] = 0.00000000000000000000;
data->test_solve_P_A_new_y[2] = 0.00000000000000000000;
data->test_solve_P_A_new_y[3] = 0.00000000000000000000;
data->test_solve_P_A_new_y[4] = 0.00000000000000000000;
data->test_solve_P_A_new_y[5] = 0.00000000000000000000;
data->test_solve_P_A_new_y[6] = 0.00000000000000000000;
data->test_solve_P_A_new_y[7] = 0.00000000000000000000;
data->test_solve_P_A_new_obj_value = -2.14908993117262525629;
data->test_solve_P_A_new_status = OSQP_SOLVED;

return data;

}

/* function to clean data struct */
void clean_problem_update_matrices_sols_data(update_matrices_sols_data * data){

c_free(data->test_form_KKT_A->x);
c_free(data->test_form_KKT_A->i);
c_free(data->test_form_KKT_A->p);
c_free(data->test_form_KKT_A);
c_free(data->test_form_KKT_Pu->x);
c_free(data->test_form_KKT_Pu->i);
c_free(data->test_form_KKT_Pu->p);
c_free(data->test_form_KKT_Pu);
c_free(data->test_form_KKT_KKT->x);
c_free(data->test_form_KKT_KKT->i);
c_free(data->test_form_KKT_KKT->p);
c_free(data->test_form_KKT_KKT);
c_free(data->test_form_KKT_KKTu->x);
c_free(data->test_form_KKT_KKTu->i);
c_free(data->test_form_KKT_KKTu->p);
c_free(data->test_form_KKT_KKTu);
c_free(data->test_form_KKT_A_new->x);
c_free(data->test_form_KKT_A_new->i);
c_free(data->test_form_KKT_A_new->p);
c_free(data->test_form_KKT_A_new);
c_free(data->test_form_KKT_Pu_new->x);
c_free(data->test_form_KKT_Pu_new->i);
c_free(data->test_form_KKT_Pu_new->p);
c_free(data->test_form_KKT_Pu_new);
c_free(data->test_form_KKT_KKT_new->x);
c_free(data->test_form_KKT_KKT_new->i);
c_free(data->test_form_KKT_KKT_new->p);
c_free(data->test_form_KKT_KKT_new);
c_free(data->test_form_KKT_KKTu_new->x);
c_free(data->test_form_KKT_KKTu_new->i);
c_free(data->test_form_KKT_KKTu_new->p);
c_free(data->test_form_KKT_KKTu_new);
c_free(data->test_solve_Pu->x);
c_free(data->test_solve_Pu->i);
c_free(data->test_solve_Pu->p);
c_free(data->test_solve_Pu);
c_free(data->test_solve_q);
c_free(data->test_solve_A->x);
c_free(data->test_solve_A->i);
c_free(data->test_solve_A->p);
c_free(data->test_solve_A);
c_free(data->test_solve_l);
c_free(data->test_solve_u);
c_free(data->test_solve_x);
c_free(data->test_solve_y);
c_free(data->test_solve_Pu_new->x);
c_free(data->test_solve_Pu_new->i);
c_free(data->test_solve_Pu_new->p);
c_free(data->test_solve_Pu_new);
c_free(data->test_solve_P_new_x);
c_free(data->test_solve_P_new_y);
c_free(data->test_solve_A_new->x);
c_free(data->test_solve_A_new->i);
c_free(data->test_solve_A_new->p);
c_free(data->test_solve_A_new);
c_free(data->test_solve_A_new_x);
c_free(data->test_solve_A_new_y);
c_free(data->test_solve_P_A_new_x);
c_free(data->test_solve_P_A_new_y);

c_free(data);

}

#endif
