/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractOutput;

public class NDeadSchoolOutput
extends AbstractOutput {
    private double[] nDeadSchool;

    public NDeadSchoolOutput(int rank) {
        super(rank);
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        this.nDeadSchool = new double[this.getNSpecies()];
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet()) {
            if (school.isAlive()) continue;
            int n = school.getSpeciesIndex();
            this.nDeadSchool[n] = this.nDeadSchool[n] + 1.0;
        }
    }

    @Override
    public void write(float time) {
        this.writeVariable(time, this.nDeadSchool);
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_ndeadschool_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        return "Ratio of the number of dead schools over the total number of schools per species per time step of saving.";
    }

    @Override
    String[] getHeaders() {
        String[] species = new String[this.getNSpecies()];
        for (int i = 0; i < species.length; ++i) {
            species[i] = this.getSimulation().getSpecies(i).getName();
        }
        return species;
    }
}

