/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose;

import fr.ird.osmose.Configuration;
import fr.ird.osmose.Osmose;
import fr.ird.osmose.Plankton;
import fr.ird.osmose.School;
import fr.ird.osmose.SchoolSet;
import fr.ird.osmose.Species;
import fr.ird.osmose.UniformPlankton;
import fr.ird.osmose.ltl.LTLForcing;
import fr.ird.osmose.output.SchoolSetSnapshot;
import fr.ird.osmose.process.PopulatingProcess;
import fr.ird.osmose.process.mortality.MortalityCause;
import fr.ird.osmose.step.AbstractStep;
import fr.ird.osmose.step.DefaultStep;
import fr.ird.osmose.util.logging.OLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import ucar.nc2.NetcdfFile;

public class Simulation
extends OLogger {
    private final int rank;
    private SchoolSet schoolSet;
    private LTLForcing forcing;
    private int year;
    private int i_step_year;
    private int i_step_simu;
    private int n_steps_simu;
    private Species[] species;
    private Plankton[] ltlGroups;
    private AbstractStep step;
    private SchoolSetSnapshot snapshot;
    private int restartFrequency;
    private boolean restart;
    private int spinupRestart;
    private boolean writeRestart;
    private boolean preyRecord;
    private int yearOutput;

    public Simulation(int rank) {
        super(rank);
        this.rank = rank;
    }

    public void destroy() {
        for (School school : this.schoolSet) {
            school.setNdead(MortalityCause.OUT, Double.MAX_VALUE);
        }
        this.schoolSet.removeDeadSchools();
        this.schoolSet = null;
        this.species = null;
        this.ltlGroups = null;
        this.step = null;
        this.forcing = null;
        this.snapshot = null;
    }

    public void init() {
        this.schoolSet = new SchoolSet();
        boolean oneStep = false;
        if (this.getConfiguration().canFind("simulation.onestep")) {
            oneStep = this.getConfiguration().getBoolean("simulation.onestep");
        }
        this.n_steps_simu = oneStep ? 1 : this.getConfiguration().getNYear() * this.getConfiguration().getNStepYear();
        this.year = 0;
        this.i_step_year = 0;
        this.i_step_simu = 0;
        this.restart = false;
        if (!this.getConfiguration().isNull("simulation.restart.file")) {
            String ncfile = this.getConfiguration().getFile("simulation.restart.file") + "." + this.rank;
            this.i_step_simu = 0;
            try {
                NetcdfFile nc = NetcdfFile.open(ncfile);
                this.i_step_simu = Integer.valueOf(nc.findGlobalAttribute("step").getStringValue()) + 1;
                if (oneStep) {
                    this.n_steps_simu = this.i_step_simu + 1;
                }
                int nStepYear = this.getConfiguration().getNStepYear();
                this.year = this.i_step_simu / nStepYear;
                this.i_step_year = this.i_step_simu % nStepYear;
                this.info("Restarting simulation from year {0} step {1}", new Object[]{this.year, this.i_step_year});
                this.restart = true;
            }
            catch (IOException ex) {
                this.error("Failed to open restart file " + ncfile, ex);
            }
        }
        this.species = new Species[this.getConfiguration().getNSpecies()];
        for (int i = 0; i < this.species.length; ++i) {
            this.species[i] = new Species(i);
            if (this.species[i].getName().matches("^[a-zA-Z0-9]*$")) continue;
            this.error("Species name must contain alphanumeric characters only. Please rename " + this.species[i].getName(), null);
        }
        this.ltlGroups = new Plankton[this.getConfiguration().getNPlankton()];
        for (int p = 0; p < this.ltlGroups.length; ++p) {
            this.ltlGroups[p] = this.getConfiguration().canFind("plankton.biomass.total.plk" + p) ? new UniformPlankton(this.rank, p) : new Plankton(this.rank, p);
            this.ltlGroups[p].init();
            if (this.ltlGroups[p].getName().matches("^[a-zA-Z0-9]*$")) continue;
            this.error("Plankton name must contain alphanumeric characters only. Please rename " + this.ltlGroups[p].getName(), null);
        }
        this.initForcing();
        this.preyRecord = false;
        this.step = new DefaultStep(this.rank);
        this.step.init();
        PopulatingProcess populatingProcess = new PopulatingProcess(this.rank);
        populatingProcess.init();
        populatingProcess.run();
        this.snapshot = new SchoolSetSnapshot(this.rank);
        this.restartFrequency = Integer.MAX_VALUE;
        if (!this.getConfiguration().isNull("output.restart.recordfrequency.ndt")) {
            this.restartFrequency = this.getConfiguration().getInt("output.restart.recordfrequency.ndt");
        }
        this.spinupRestart = 0;
        if (!this.getConfiguration().isNull("output.restart.spinup")) {
            this.spinupRestart = this.getConfiguration().getInt("output.restart.spinup") - 1;
        }
        this.writeRestart = true;
        if (!this.getConfiguration().isNull("output.restart.enabled")) {
            this.writeRestart = this.getConfiguration().getBoolean("output.restart.enabled");
        } else {
            this.warning("Could not find parameter 'output.restart.enabled'. Osmose assumes it is true and a NetCDF restart file will be created at the end of the simulation (or more, depending on parameters 'simulation.restart.recordfrequency.ndt' and 'simulation.restart.spinup').");
        }
        this.yearOutput = this.getConfiguration().getInt("output.start.year");
    }

    private void initForcing() {
        String ltlClassName = this.getConfiguration().getString("ltl.java.classname");
        String errMsg = "Failed to create new LTLForcing instance";
        try {
            this.info("LTLForcing: " + ltlClassName);
            this.forcing = (LTLForcing)Class.forName(ltlClassName).getConstructor(Integer.TYPE).newInstance(this.rank);
        }
        catch (ClassNotFoundException ex) {
            this.error(errMsg, ex);
        }
        catch (IllegalAccessException ex) {
            this.error(errMsg, ex);
        }
        catch (IllegalArgumentException ex) {
            this.error(errMsg, ex);
        }
        catch (InstantiationException ex) {
            this.error(errMsg, ex);
        }
        catch (NoSuchMethodException ex) {
            this.error(errMsg, ex);
        }
        catch (SecurityException ex) {
            this.error(errMsg, ex);
        }
        catch (InvocationTargetException ex) {
            this.error(errMsg, ex);
        }
        this.forcing.init();
    }

    public boolean isRestart() {
        return this.restart;
    }

    public void run() {
        while (this.i_step_simu < this.n_steps_simu) {
            this.year = this.i_step_simu / this.getConfiguration().getNStepYear();
            this.i_step_year = this.i_step_simu % this.getConfiguration().getNStepYear();
            if (this.i_step_simu % this.getConfiguration().getNStepYear() == 0) {
                if (this.getConfiguration().getNCpu() > 1) {
                    this.debug("year {0}", this.year);
                } else {
                    this.info("year {0}", this.year);
                }
            }
            this.step.step(this.i_step_simu);
            if (this.writeRestart && this.year >= this.spinupRestart && (this.i_step_simu + 1) % this.restartFrequency == 0) {
                this.snapshot.makeSnapshot(this.i_step_simu);
            }
            ++this.i_step_simu;
        }
        this.step.end();
        if (this.writeRestart) {
            this.snapshot.makeSnapshot(this.i_step_simu - 1);
        }
    }

    public SchoolSet getSchoolSet() {
        return this.schoolSet;
    }

    public Species getSpecies(int index) {
        return this.species[index];
    }

    public Plankton getPlankton(int index) {
        return this.ltlGroups[index];
    }

    public int getYear() {
        return this.year;
    }

    public int getIndexTimeYear() {
        return this.i_step_year;
    }

    public int getIndexTimeSimu() {
        return this.i_step_simu;
    }

    public boolean isPreyRecord() {
        return this.preyRecord && this.year >= this.yearOutput - 1;
    }

    public void requestPreyRecord() {
        this.preyRecord = true;
    }

    private Configuration getConfiguration() {
        return Osmose.getInstance().getConfiguration();
    }

    public LTLForcing getForcing() {
        return this.forcing;
    }
}

