/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.Prey;
import fr.ird.osmose.School;
import fr.ird.osmose.output.IOutput;
import fr.ird.osmose.stage.DietOutputStage;
import fr.ird.osmose.stage.IStage;
import fr.ird.osmose.util.SimulationLinker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DietOutput
extends SimulationLinker
implements IOutput {
    private FileOutputStream fos;
    private PrintWriter prw;
    private int recordFrequency;
    private double[][][][] diet;
    private double[][] abundanceStage;
    private IStage dietOutputStage;
    private final String separator = this.getConfiguration().getOutputSeparator();

    public DietOutput(int rank) {
        super(rank);
        this.getSimulation().requestPreyRecord();
    }

    @Override
    public void initStep() {
    }

    @Override
    public void reset() {
        int nSpec = this.getNSpecies();
        int nPrey = nSpec + this.getConfiguration().getNPlankton();
        this.diet = new double[nSpec][][][];
        this.abundanceStage = new double[nSpec][];
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            int nStage = this.dietOutputStage.getNStage(iSpec);
            this.diet[iSpec] = new double[nStage][][];
            this.abundanceStage[iSpec] = new double[nStage];
            for (int iStage = 0; iStage < nStage; ++iStage) {
                this.diet[iSpec][iStage] = new double[nPrey][];
                for (int iPrey = 0; iPrey < nPrey; ++iPrey) {
                    this.diet[iSpec][iStage][iPrey] = iPrey < nSpec ? new double[this.dietOutputStage.getNStage(iPrey)] : new double[1];
                }
            }
        }
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getPresentSchools()) {
            double preyedBiomass = school.getPreyedBiomass();
            int iSpec = school.getSpeciesIndex();
            if (!(preyedBiomass > 0.0)) continue;
            double[] dArray = this.abundanceStage[iSpec];
            int n = this.dietOutputStage.getStage(school);
            dArray[n] = dArray[n] + school.getAbundance();
            for (Prey prey : school.getPreys()) {
                double[] dArray2 = this.diet[iSpec][this.dietOutputStage.getStage(school)][prey.getSpeciesIndex()];
                int n2 = this.dietOutputStage.getStage(prey);
                dArray2[n2] = dArray2[n2] + school.getAbundance() * prey.getBiomass() / preyedBiomass;
            }
        }
    }

    @Override
    public void write(float time) {
        int nSpec = this.getConfiguration().getNSpecies();
        for (int iSpec = 0; iSpec < nSpec; ++iSpec) {
            String name = this.getSimulation().getSpecies(iSpec).getName();
            float[] threshold = this.dietOutputStage.getThresholds(iSpec);
            int nStagePred = this.dietOutputStage.getNStage(iSpec);
            for (int st = 0; st < nStagePred; ++st) {
                this.prw.print(time);
                this.prw.print(this.separator);
                if (nStagePred == 1) {
                    this.prw.print(name);
                } else if (st == 0) {
                    this.prw.print(this.quote(name + " < " + threshold[st]));
                } else {
                    this.prw.print(this.quote(name + " >=" + threshold[st - 1]));
                }
                this.prw.print(this.separator);
                for (int i = 0; i < nSpec; ++i) {
                    int nStagePrey = this.dietOutputStage.getNStage(i);
                    for (int s = 0; s < nStagePrey; ++s) {
                        if (this.abundanceStage[i][s] > 0.0) {
                            this.prw.print((float)(100.0 * this.diet[i][s][iSpec][st] / this.abundanceStage[i][s]));
                        } else {
                            this.prw.print("NaN");
                        }
                        if (i >= nSpec - 1 && s >= nStagePrey - 1) continue;
                        this.prw.print(this.separator);
                    }
                }
                this.prw.println();
            }
        }
        for (int j = nSpec; j < nSpec + this.getConfiguration().getNPlankton(); ++j) {
            this.prw.print(time);
            this.prw.print(this.separator);
            this.prw.print(this.getSimulation().getPlankton(j - nSpec));
            this.prw.print(this.separator);
            for (int i = 0; i < nSpec; ++i) {
                int nStagePred = this.dietOutputStage.getNStage(i);
                for (int s = 0; s < nStagePred; ++s) {
                    if (this.abundanceStage[i][s] > 0.0) {
                        float val = (float)(100.0 * this.diet[i][s][j][0] / this.abundanceStage[i][s]);
                        String sval = Float.isInfinite(val) ? "Inf" : Float.toString(val);
                        this.prw.print(sval);
                    } else {
                        this.prw.print("NaN");
                    }
                    if (i >= nSpec - 1 && s >= nStagePred - 1) continue;
                    this.prw.print(this.separator);
                }
            }
            this.prw.println();
        }
    }

    @Override
    public void init() {
        this.recordFrequency = this.getConfiguration().getInt("output.recordfrequency.ndt");
        this.dietOutputStage = new DietOutputStage();
        this.dietOutputStage.init();
        File path = new File(this.getConfiguration().getOutputPathname());
        StringBuilder filename = new StringBuilder("Trophic");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_dietMatrix_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        File file = new File(path, filename.toString());
        boolean fileExists = file.exists();
        file.getParentFile().mkdirs();
        try {
            this.fos = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DietOutput.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.prw = new PrintWriter(this.fos, true);
        if (!fileExists) {
            this.prw.println(this.quote("% of prey species (in rows) in the diet of predator species (in col)"));
            this.prw.print(this.quote("Time"));
            this.prw.print(this.separator);
            this.prw.print(this.quote("Prey"));
            for (int iSpec = 0; iSpec < this.getNSpecies(); ++iSpec) {
                String name = this.getSimulation().getSpecies(iSpec).getName();
                float[] threshold = this.dietOutputStage.getThresholds(iSpec);
                int nStage = this.dietOutputStage.getNStage(iSpec);
                for (int iStage = 0; iStage < nStage; ++iStage) {
                    this.prw.print(this.separator);
                    if (nStage == 1) {
                        this.prw.print(name);
                        continue;
                    }
                    if (iStage == 0) {
                        this.prw.print(this.quote(name + " < " + threshold[iStage]));
                        continue;
                    }
                    this.prw.print(this.quote(name + " >=" + threshold[iStage - 1]));
                }
            }
            this.prw.println();
        }
    }

    @Override
    public void close() {
        if (null != this.prw) {
            this.prw.close();
        }
        if (null != this.fos) {
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DietOutput.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public boolean isTimeToWrite(int iStepSimu) {
        return (iStepSimu + 1) % this.recordFrequency == 0;
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }
}

